
// Implementation of the InitTrailerReader class.
 

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cxx/logger.h>
extern "C" {
#include <sys/time.h>
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

#include "event/InitTrailerEvent.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.InitTrailerReader"));

/**
 * Constructor. 
 */
InitTrailerReader::InitTrailerReader(void): 
  TechmodelAlgorithm(PacketType::InitTrailer, "TechmodelInitTrailerReader") { 
  logger->debug(_T("Constructor"));
  initTrailer = new InitTrailerEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string InitTrailerReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/InitTrailerReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void InitTrailerReader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &initTrailer, initTrailer->Class());
}

/**
 * Unpack the InitTrailer event from an input file.
 */
void InitTrailerReader::RunEvent(int EventNumber, long int length) throw (WrongCRCException){
    logger->debug(_T("RunEvent"));
    
}

