/**     @file
 * $Source: /home/cvsmanager/yoda/event/EventCounter.h,v $
 * $Id: EventCounter.h,v 3.0 2005/03/04 15:54:11 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Header file for the EventCounter class.
 */
#ifndef EVENTCOUNTER_H
#define EVENTCOUNTER_H

#include <map>
#include "Exception.h"
#include "PscuHeader.h"

namespace pamela {
  /**
   * Event counter. Contains the event numbers of the last read event of 
   * each event type.
   */
  class EventCounter : public TObject {
  private:
    int RunNumber;    /**< Run number */

    int Pscu;
    int PhysEndRun;
    int CalibCalPulse1;
    int CalibCalPulse2;
    int Physics;
    int CalibTrkBoth;
    int CalibTrk1;
    int CalibTrk2;
    int CalibCal;
    int CalibTrd;
    int CalibTof;
    int CalibS4;
    int CalibCalPed;
    int Calib1_Ac1;
    int Calib1_Ac2;
    int Calib2_Ac1;
    int Calib2_Ac2;
    int RunHeader;
    int RunTrailer;
    int CalibHeader;
    int CalibTrailer;
    int InitHeader;
    int InitTrailer;
    int EventTrk;
    int TestTrk;
    int TestTof;
    int Log;
    int VarDump;
    int ArrDump;
    int TabDump;
    int Tmtc;
    int Mcmd;
    int ForcedFECmd;
    int Ac1Init;
    int CalInit;
    int TrkInit;
    int TofInit;
    int TrgInit;
    int NdInit;
    int S4Init;
    int Ac2Init;
    int CalAlarm;
    int AcAlarm;
    int TrkAlarm;
    int TrgAlarm;
    int TofAlarm;
    int S4Alarm;
    int TsbT;
    int TsbB;

    typedef std::map<const pamela::PacketType *, int *> CounterMap;
    CounterMap CMap; //!
    
  public:
    EventCounter(int = 0);
    /** Get the run number for the last read event of this type. */
    int getPscu() const { return Pscu; };
    /** Get the run number for the last read event of this type. */
    int Get(pamela::PacketType const *) const throw (NotExistingCounterException);
    /** Get the run number for the next event of this type. */
    int Next(pamela::PacketType const *) const throw (NotExistingCounterException);
    int GetRunNumber(void) const { return RunNumber; }
    void Increment(pamela::PacketType const *) throw (NotExistingCounterException);
    void PrintCounters() const ;
    ClassDef(EventCounter, 3)
  };
}

#endif /* EVENTCOUNTER_H */


