
// Implementation of the TofAlarmReader class.
 

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cxx/logger.h>
extern "C" {
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.TofAlarmReader"));

/**
 * Constructor. 
 */
TofAlarmReader::TofAlarmReader(void): 
  TechmodelAlgorithm(PacketType::TofAlarm, "TechmodelTofAlarmReader") { 
  logger->debug(_T("Constructor"));
  tofAlarm = new TofAlarmEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string TofAlarmReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/TofAlarmReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void TofAlarmReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &tofAlarm, tofAlarm->Class());
  logger->debug(_T("Initialize"));
}

/**
 * Unpack the TofAlarm event from an input file.
 */
void TofAlarmReader::RunEvent(int EventNumber, long int length) throw (WrongCRCException){
    
    
}

