/** @file
 * $Source: /home/cvsmanager/yoda/techmodel/TechmodelPamelaRun.cpp,v $
 * $Id: TechmodelPamelaRun.cpp,v 3.0 2005/03/04 15:54:11 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Implementation of the TechmodelPamelaRun class.
 */
#include <string>
#include <exception>
#include <iostream>
#include <fstream>
#include <log4cxx/logger.h>

#include "TechmodelPamelaRun.h"

using namespace pamela;
using namespace pamela::techmodel;


static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.TechmodelPamelaRun"));

/**
 * Create a new Pamela run structure to write the data from the 
 * techmodel data files into the ROOT TTrees.
 * @param run Run number
 */
TechmodelPamelaRun::TechmodelPamelaRun(std::string fileName, std::string path) :
  PamelaRun(fileName, path) {
  InputFile = new ifstream(fileName.c_str(), std::ios::binary); //inserito ios::binary maurizio 01/03/2004
  if (!*InputFile){
    std::stringstream oss;
    oss.str("");
    oss << "Cannot open file " << fileName;
    logger->error(oss.str().c_str());
    throw std::exception();
  }
  else
    {
  // :TODO: InputFile should be a dervived class for cross-checking of 
  // packet lengths.      
    }

}





