/** @file
 * $Author: kusanagi $
 * $Date: 2005/03/04 15:54:11 $
 * $Revision: 3.0 $
 * 
 * Header file for the algorithms used to read the techmodel data file.
 */

#ifndef TECHMODEL_ALGORITHM_H
#define TECHMODEL_ALGORITHM_H

#include "event/Algorithm.h"
#include "event/Exception.h"

namespace pamela {
  namespace techmodel {
    /**
     * Base algorithm for all techmodel reader.
     */
    class TechmodelAlgorithm: public Algorithm {
    protected:
      ifstream *InputFile; //!
      void SetInputStream(PamelaRun*);
      TechmodelAlgorithm(const PacketType*, std::string);
    public:
      virtual void Init(PamelaRun*);
      virtual void RunEvent(int, long int = 0) throw (Exception){}
      ClassDef(TechmodelAlgorithm, 1)
    };
  }
}

#endif /* TECHMODEL_ALGORITHM_H */


