/** @file
 * $Author: kusanagi $
 * $Date: 2005/03/04 15:54:11 $
 * $Revision: 3.0 $
 * 
 * Implementation of the base class for the algorithms used to read the 
 * techmodel data file of Pamela.
 */


#include "TechmodelAlgorithm.h"
#include "TechmodelPamelaRun.h"

using namespace pamela;
using namespace pamela::techmodel;

TechmodelAlgorithm::TechmodelAlgorithm(const PacketType* type, std::string name): 
  Algorithm(type, name) {
}

/**
 * Set the input stream used to read the techmodel file.
 */
void TechmodelAlgorithm::SetInputStream(PamelaRun* run) {
  InputFile = (dynamic_cast<TechmodelPamelaRun*>(run))->GetInputFile();
}

/**
 * On default, the Init() function just calls the SetInputStream().
 */
void TechmodelAlgorithm::Init(PamelaRun* run) {
  SetInputStream(run);
}

ClassImp(TechmodelAlgorithm)
