
// Implementation of the AcAlarmReader class.
 

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cxx/logger.h>
extern "C" {
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.AcAlarmReader"));

/**
 * Constructor. 
 */
AcAlarmReader::AcAlarmReader(void): 
  TechmodelAlgorithm(PacketType::AcAlarm, "TechmodelAcAlarmReader") { 
  logger->debug(_T("Constructor"));
  acAlarm = new AcAlarmEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string AcAlarmReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/acAlarmReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void AcAlarmReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &acAlarm, acAlarm->Class());
  logger->debug(_T("Initialize"));
}

/**
 * Unpack the AcAlarm event from an input file.
 */
void AcAlarmReader::RunEvent(int EventNumber, long int length) throw (WrongCRCException){
    
    
}

