
#ifndef NEUTRON_RECORD_H
#define NEUTRON_RECORD_H

#define UINT8  unsigned char

#include <TObject.h>


namespace pamela {
    namespace neutron {
    /**
    * NeutronRecord data Wrapper
    */
    class NeutronRecord: public TObject {

    public:
    /**
     * Get the run name according to a certain run number.
     * @param run Run number.
     * @return a string with the run name.
     */

    UINT8    trigPhysics; //Counter during physics events
    UINT8    upperBack;   //High   plane counter background
    UINT8    bottomBack;  //Bottom plane counter background

    NeutronRecord(void);
        
    ClassDef(NeutronRecord, 1)
  };
}
}
#endif /* NEUTRON_RECORD_H */

