/** @file
 * $Source: /home/cvsmanager/yoda/event/log/LogEvent.h,v $
 * $Id: LogEvent.h,v 3.0 2005/03/04 15:54:11 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Header file for the LogEvent class.
 */
#ifndef LOG_EVENT_H
#define LOG_EVENT_H

#include <vector>
#include "event/SubPacket.h"
#include "event/log/LogRecord.h"
#include <TClonesArray.h>

using namespace std;

namespace pamela {
  /**
   * LogEvent data Wrapper
   */
  class LogEvent: public pamela::SubPacket {
  private:
    static TClonesArray *fgRecords;
  public:
    /**
     * Get the run name according to a certain run number.
     * @param run Run number.
     * @return a string with the run name.
     */
    UINT32 COMPILATION_TIMESTAMP;
    TClonesArray* Records;
    
    LogEvent(void);
    ~LogEvent(void);
    
    ClassDef(LogEvent, 1)
  };
}

#endif /* LOG_EVENT_H */

