/** @file
 * $Source: /home/cvsmanager/yoda/techmodel/RunHeaderReader.cpp,v $
 * $Id: RunHeaderReader.cpp,v 3.1 2005/03/06 04:29:20 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Implementation of the RunHeader class.
*/


#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cxx/logger.h>
extern "C" {
#include <sys/time.h>
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

#include "event/RunHeaderEvent.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.RunHeaderReader"));

/**
 * Constructor. 
 */
RunHeaderReader::RunHeaderReader(void): 
  TechmodelAlgorithm(PacketType::Log, "TechmodelRunHeaderReader") { 
  logger->debug(_T("Constructor"));
  RunHeader = new RunHeaderEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string RunHeaderReader::GetVersionInfo(void) const {
  return 
    "$Header: /home/cvsmanager/yoda/techmodel/RunHeaderReader.cpp,v 3.1 2005/03/06 04:29:20 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void RunHeaderReader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &RunHeader, RunHeader->Class());
}

/**
 * Unpack the RunHeader event from an input file.
 */
void RunHeaderReader::RunEvent(int EventNumber, long int length) throw (WrongCRCException){

    char      subData[length];
    UINT16    subCRC;                   //calculated CRC of the data
    UINT16    readCRC;                  //CRC read from the end of the subpacket
    long int  dataLength = length - 2;  //the block of data
    
    InputFile->read(subData, sizeof(subData));
    subCRC = CM_Compute_CRC16(0, (UINT8*)subData, dataLength);
    readCRC = (((UINT16)(subData[length - 2]<<8))&0xFF00) + (((UINT16)subData[length - 1])&0x00FF);

    if (subCRC != readCRC) throw WrongCRCException(" Wrong CRC for RunHeader Packet ");

    RunHeader->COMPILATIONTIMESTAMP       = (((UINT32)subData[0]<<24)&0xFF000000) + (((UINT32)subData[1]<<16)&0x00FF0000) +  (((UINT32)subData[2]<<8)&0x0000FF00)  + (((UINT32)subData[3])&0x000000FF);
    RunHeader->RM_ACQ_SETTING_MODE        = (BYTE)subData[4];
    RunHeader->OBT_TIME_SYNC              = (((UINT32)subData[5]<<24)&0xFF000000) + (((UINT32)subData[6]<<16)&0x00FF0000) +  (((UINT32)subData[7]<<8)&0x0000FF00)  + (((UINT32)subData[8])&0x000000FF);
    RunHeader->LAST_TYME_SYNC_INFO        = (((UINT32)subData[9]<<24)&0xFF000000) + (((UINT32)subData[10]<<16)&0x00FF0000) +  (((UINT32)subData[11]<<8)&0x0000FF00) + (((UINT32)subData[12])&0x000000FF);
    RunHeader->FAVOURITE_WORKING_SCHEDULE = (BYTE)subData[13];
    RunHeader->EFFECTIVE_WORKING_SCHEDULE = (BYTE)subData[14];
    RunHeader->PRH_VAR_TRIGGER_MODE_A     = (((UINT32)subData[15]<<24)&0xFF000000) + (((UINT32)subData[16]<<16)&0x00FF0000) +  (((UINT32)subData[17]<<8)&0x0000FF00) + (((UINT32)subData[18])&0x000000FF);
    RunHeader->PRH_VAR_TRIGGER_MODE_B     = (((UINT32)subData[19]<<24)&0xFF000000) + (((UINT32)subData[20]<<16)&0x00FF0000) +  (((UINT32)subData[21]<<8)&0x0000FF00) + (((UINT32)subData[22])&0x000000FF);
    RunHeader->RM_ACQ_AFTER_CALIB         = (BYTE)subData[23];
    RunHeader->TRK_CALIB_USED             = (((UINT32)subData[24]<<24)&0xFF000000) + (((UINT32)subData[25]<<16)&0x00FF0000) +  (((UINT32)subData[26]<<8)&0x0000FF00) + (((UINT32)subData[27])&0x000000FF);
    RunHeader->ACQ_BUILD_INFO             = (((UINT32)subData[28]<<24)&0xFF000000) + (((UINT32)subData[29]<<16)&0x00FF0000) +  (((UINT32)subData[30]<<8)&0x0000FF00) + (((UINT32)subData[31])&0x000000FF);
    RunHeader->ACQ_VAR_INFO               = (BYTE)subData[32];
    RunHeader->CAL_DSP_MASK               = (BYTE)subData[33];
    
}
