
// Implementation of the AcInitReader class.
 

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cxx/logger.h>
extern "C" {
    #include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"


using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.AcInitReader"));

/**
 * Constructor. 
 */
AcInitReader::AcInitReader(void): 
  TechmodelAlgorithm(PacketType::AcInit, "TechmodelAcInitReader") { 
  logger->debug(_T("Constructor"));
  acInit = new AcInitEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string AcInitReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/AcInitReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void AcInitReader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &acInit, acInit->Class());
}

/**
 * Unpack the AcInit event from an input file.
 */
void AcInitReader::RunEvent(int EventNumber, long int length) {
    
    
}

