#include <stdio.h>
#include "ACcalib.h"

// Program to read AC calibration data
// 0408 Petter Hofverberg, petter@particle.kth.se

int ACcalib(int length, unsigned short* datapointer, struct datastruct* calibpointer)
{
  int iter=2;

  //point struc-pointer to calibdata
  *calibpointer=calibdata;  

  //look for header 0xACCA
  while(found==0 && iter<length)
    {
      tmp1=*datapointer;
      tmp2=*(datapointer+1);
      if(tmp1==0xCAAC)
	{
	  found=1;
	  for(i=0;i<8256;i++)
	    {
	      buffer[i]=*datapointer;
	      datapointer++;
	    }
	  tmp1=0x0000;
	}
      else if((tmp1&0x00FF) + (tmp2&0xFF00)==0xACCA)
	{
	  found=1;
	  for(i=0;i<8256;i++)
	    {
	      buffer[i]=(tmp1&0x00FF) + (tmp2&0xFF00);
	      datapointer++;
	      tmp1=tmp2;
	      tmp2=*(datapointer+1);
	    }
	}
      else{
      datapointer++;
      iter=iter+2;}
    }

  //check errors
  if(iter>=length)
    err=2;
  else if(buffer[8254]==0x22AC)
    err=0;
  else
    err=1;

  //Fill calibdata from buffer
  calibdata.header=buffer[0];
  for(i=0;i<5;i++) calibdata.status[i]=buffer[1+i];
  for(i=0;i<8;i++) calibdata.temp[i]=buffer[6+i];
  for(i=0;i<8;i++) calibdata.DAC1[i]=buffer[14+i];
  for(i=0;i<8;i++) calibdata.DAC2[i]=buffer[22+i];
  for(i=0;i<6;i++) calibdata.regist[i]=buffer[30+i];
  for(i=0;i<8;i++) calibdata.time[i]=buffer[36+i];
  calibdata.n_tr=buffer[44];
  for(i=0;i<16;i++) calibdata.hitmap_tr[i]=buffer[45+i];
  for(i=0;i<4096;i++) calibdata.curve1[i]=buffer[61+i];
  for(i=0;i<4096;i++) calibdata.curve2[i]=buffer[4157+i];
  calibdata.iCRC=buffer[8253];
  calibdata.tail=buffer[8254];
  calibdata.CRC=buffer[8255];
  
  /*  
  //debug
  printf("header: %hx\n",calibdata.header);
  printf("status: %hx\n",calibdata.status[0]);
  printf("temp: %hx\n",calibdata.temp[0]);
  printf("DAC1: %hx\n",calibdata.DAC1[0]);
  printf("DAC2: %hx\n",calibdata.DAC2[0]);
  printf("regist: %hx\n",calibdata.regist[0]);
  printf("time: %hx\n",calibdata.time[0]);
  printf("n_tr: %hx\n",calibdata.n_tr);
  printf("hitmap_tr: %hx\n",calibdata.hitmap_tr[0]);
  printf("curve1: %hx\n",calibdata.curve1[0]);
  printf("curve2: %hx\n",calibdata.curve2[0]);
  printf("iCRC: %hx\n",calibdata.iCRC);
  printf("tail: %hx\n",calibdata.tail);
  printf("CRC: %hx\n",calibdata.CRC);
  printf("err: %d\n",err);
  */

  return err;
}

