
// Implementation of the CalibTrkBothReader class.
 

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cpp/Category.hh>
extern "C" {
#include <sys/time.h>
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

#include "event/CalibTrkBothEvent.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cpp::Category& cat = log4cpp::Category::getInstance("pamela.techmodel.CalibTrkBothReader");  

/**
 * Constructor. 
 */
CalibTrkBothReader::CalibTrkBothReader(void): 
  TechmodelAlgorithm(PacketType::CalibTrkBoth, "TechmodelCalibTrkBothReader") { 
  cat <<  log4cpp::Priority::DEBUG
      <<  "Constructor "
      <<  "\n " << log4cpp::CategoryStream::ENDLINE;
  calibTrkBoth = new CalibTrkBothEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string CalibTrkBothReader::GetVersionInfo(void) const {
  return 
    "$Header: /home/cvsmanager/yoda/techmodel/CalibTrkBothReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void CalibTrkBothReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &calibTrkBoth, calibTrkBoth->Class());
}

/**
 * Unpack the CalibTrkBoth event from an input file.
 */
void CalibTrkBothReader::RunEvent(int EventNumber, long int length) {
    
    
}

