/** @file
 * $Source: /home/cvsmanager/yoda/techmodel/CalibAcReader.cpp,v $
 * $Id: CalibAcReader.cpp,v 1.3 2004/08/24 16:01:57 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Implementation of the ArrDumpReader class.
 */

#include <string>
#include <log4cpp/Category.hh>
#include <fstream>
#include "stdio.h"
extern "C" {
    #include "CRC.h"
    #include "forroutines/anticounter/ACcalib.h"
    extern int ACcalib(int length, unsigned short* datapointer, struct datastruct* calibpointer);
}

#include "ReaderAlgorithms.h"

using namespace pamela;
using namespace pamela::techmodel;


static log4cpp::Category& cat = log4cpp::Category::getInstance("pamela.techmodel.CalibAcReader");  

/**
 * Constructor. 
 */
CalibAcReader::CalibAcReader(void): 
  TechmodelAlgorithm(PacketType::CalibAc, "TechmodelCalibAc") { 
  CalibAc = new CalibAcEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string CalibAcReader::GetVersionInfo(void) const {
  return "$Header: /home/cvsmanager/yoda/techmodel/CalibAcReader.cpp,v 1.3 2004/08/24 16:01:57 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void CalibAcReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &CalibAc, CalibAc->Class());
}

/**
 * Unpack the CalibAc event from an input file.
 */
void CalibAcReader::RunEvent(int EventNumber, long int length) {
  
  char     *subData;
  char      eventCRC[2];
  UINT16    subCRC;      //CRC of the data
  UINT16    readCRC;     //CRC read from the end of the subpacket
  long int  dataLength;
  
    //the 2 bytes subtracted belong to the final event CRC bytes
    dataLength = length - (long int)2;

    subData = new char[dataLength];
    InputFile->read(subData, sizeof(unsigned char)*dataLength);
    subCRC = CM_Compute_CRC16(0, (BYTE*)subData, dataLength);

    //took the final CRC to compare it with the previous calculated CRC of the data
    InputFile->read(eventCRC, sizeof(eventCRC));
    readCRC = (((UINT16)(eventCRC[0]<<8))&0xFF00) + (((UINT16)eventCRC[1])&0x00FF);
    
    if (subCRC == readCRC){
        datastruct output;
        int ERROR;
        ERROR = ACcalib(dataLength, (unsigned short*)subData, &output);
    
        CalibAc->header = output.header;
        memcpy(CalibAc->status,     output.status,     sizeof(CalibAc->status));
        memcpy(CalibAc->temp,       output.temp,       sizeof(CalibAc->temp));
        memcpy(CalibAc->DAC1,       output.DAC1,       sizeof(CalibAc->DAC1));
        memcpy(CalibAc->DAC2,       output.DAC2,       sizeof(CalibAc->DAC2));
        memcpy(CalibAc->regist,     output.regist,     sizeof(CalibAc->regist));
        memcpy(CalibAc->time,       output.time,       sizeof(CalibAc->time));
        CalibAc->n_tr = output.n_tr;
        memcpy(CalibAc->hitmap_tr,  output.hitmap_tr,  sizeof(CalibAc->hitmap_tr));
        memcpy(CalibAc->curve1,     output.curve1,     sizeof(CalibAc->curve1));
        memcpy(CalibAc->curve2,     output.curve2,     sizeof(CalibAc->curve2));
        CalibAc->iCRC = output.iCRC;
        CalibAc->tail = output.tail;
        CalibAc->CRC  = output.CRC;
    } else {
        cat <<  log4cpp::Priority::ERROR
            <<  "Wrong CRC on Subpacket in ArrDump Packet "
            <<  "\n " << log4cpp::CategoryStream::ENDLINE;
    }
    delete [] subData;
  }
