
// Implementation of the TestTrkReader class.
 

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cpp/Category.hh>
extern "C" {
#include <sys/time.h>
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

#include "event/TestTrkEvent.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cpp::Category& cat = log4cpp::Category::getInstance("pamela.techmodel.TestTrkReader");  

/**
 * Constructor. 
 */
TestTrkReader::TestTrkReader(void): 
  TechmodelAlgorithm(PacketType::TestTrk, "TechmodelTestTrkReader") { 
  cat <<  log4cpp::Priority::DEBUG
      <<  "Constructor "
      <<  "\n " << log4cpp::CategoryStream::ENDLINE;
  testTrk = new TestTrkEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string TestTrkReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/TestTrkReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void TestTrkReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &testTrk, testTrk->Class());
}

/**
 * Unpack the TestTrk event from an input file.
 */
void TestTrkReader::RunEvent(int EventNumber, long int length) {
    
    
}

