/** @file
 * $Source: /home/cvspamela/yoda/event/OrbitalEvent.cpp,v $
 * $Id: OrbitalEvent.cpp,v 1.6 2004/03/16 10:18:28 nagni Exp $
 * $Author: nagni $
 * 
 * Implementation of the OrbitalEvent class.
 */
#include "OrbitalEvent.h"

using namespace pamela;

OrbitalEvent::OrbitalEvent(void): SubPacket("Techmodel", PacketType::Orbital) {
}

/**
 * Set the information of the OrbitalEvent.
 * @param t Time
 * @param o Orbit number
 * @param h Height 
 */
void OrbitalEvent::Set(int t, int o, float h) {
  Time = t;
  Orbit = o;
  Height = h;
}

ClassImp(OrbitalEvent)
