/** @file
 * $Source: /home/cvspamela/yoda/techmodel/OrbitalReader.cpp,v $
 * $Id: OrbitalReader.cpp,v 1.6 2004/03/16 10:18:28 nagni Exp $
 * $Author: nagni $
 * 
 * Implementation of the OrbitalReader class.
 */

#include <string>
#include <log4cpp/Category.hh>
extern "C" {
#include <sys/time.h>
}

#include "ReaderAlgorithms.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cpp::Category& cat = log4cpp::Category::getInstance("pamela.techmodel.OrbitalReader");  

/**
 * Constructor. 
 */
OrbitalReader::OrbitalReader(void): 
  TechmodelAlgorithm(PacketType::Orbital, "TechmodelOrbitalReader") { 
  cat.debug("Constructor");
  Orbital = new OrbitalEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string OrbitalReader::GetVersionInfo(void) const {
  return 
    "$Header: /home/cvspamela/yoda/techmodel/OrbitalReader.cpp,v 1.6 2004/03/16 10:18:28 nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void OrbitalReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &Orbital, Orbital->Class());
}

/**
 * Unpack the orbital event from an input file.
 */
void OrbitalReader::RunEvent(int EventNumber, long int length) {
  // First step: unpack the event into the event class.
  struct timeval tv;
  struct timezone tz;
  gettimeofday(&tv, &tz);
  Orbital->Set(tv.tv_sec * 1000 + tv.tv_sec/1000, 1, 0);
}
