/** @file
 * $Source: /home/cvsmanager/yoda/event/RunInfo.cpp,v $
 * $Id: RunInfo.cpp,v 6.0 2006/02/07 17:11:07 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Implementation of the default functions of the Algorithm class.
 */
extern "C" {
#include <unistd.h>
#include <time.h>
#include <stdlib.h>
#include <pwd.h>
#include <sys/types.h>
}
#include "RunInfo.h"
#include "PamelaRun.h"
using namespace pamela;

RunInfo::RunInfo(PamelaRun* run):  UserName(getpwuid(geteuid())->pw_name), 
				   DataPath( run->GetUnpackPath()), 
				   RunNumber(run->GetRunNumber()) {
  char* hostname = new char[1000];
  gethostname(hostname, 1000);
  HostName = TString(hostname);

  time_t t = time(NULL);
  Time = TString(asctime(gmtime(&t)));
}

RunInfo::RunInfo(void) { }
RunInfo::~RunInfo(void) { }

ClassImp(RunInfo)
