/** @file
 * $Author: kusanagi $
 * $Date: 2006/02/04 12:37:46 $
 * $Revision: 5.1 $
 * 
 * Header file for the algorithms used to read the techmodel calorimeter events.
 */

#ifndef TOF_READER_H
#define TOF_READER_H

#include "techmodel/TechmodelAlgorithm.h"
#include "event/PamelaRun.h"
#include "event/physics/tof/TofEvent.h"


namespace pamela {
  namespace tof {
    /**
     * Algorithm to read fligthmodel calorimeter physics events.
     */
    class TofReader: public pamela::techmodel::TechmodelAlgorithm {
    private:
      /**
       * The physics event that is created in this algorithm.
       */
      TofEvent *tof;
    public:
      TofReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int);
      virtual void RunEvent(int, const char[] , long int);
      virtual std::string GetVersionInfo(void) const;
    };
  }
}

#endif /* TOF_READER_H */
