/** @file
 * $Source: /home/cvsmanager/yoda/event/Algorithm.h,v $
 * $Id: Algorithm.h,v 5.1 2006/02/04 12:37:42 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Header file for the Algorithm class.
 */
#ifndef ALGORITHM_H
#define ALGORITHM_H

#include <TObject.h> //Substituted by Maurizio 05 Feb 2004
#include "PacketType.h"


namespace pamela {
  class PamelaRun;

  /**
   * Abstract base class for all processing algorithms. You need to deviate
   * from this class and overwrite the functions Init(), RunEvent() and
   * Finish(), if necessary. For logging purposes, you also need to write
   * the functions GetName() and GetVersionInfo().
   */
  class Algorithm: public TObject {
  protected:
    /** 
     * The packet type of the events processed by this algorithm. 
     */
    const pamela::PacketType *type; //!
    /**
     * The name of the algorithm.
     */
    std::string AlgorithmName;
  public:
    
    Algorithm(const pamela::PacketType*, std::string); 
    /** 
     * Get the name of the algorithm. 
     */
    std::string GetAlgorithmName(void) const { return AlgorithmName; }
    /**
     * Get a string with the version info of the algorithm. 
     * Must be overwritten. 
     */
    virtual std::string GetVersionInfo(void) const = 0;
    /**
     * Get the type this algorithm is used for. 
     */
    const pamela::PacketType *GetPacketType(void) const { return type; }
    /**
     * Initialize the algorithm with a special run. Default: Do nothing. 
     */
    virtual void Init(pamela::PamelaRun *) { }
    /**
     * Run the algorithm with a certain event. Default: Do nothing. 
     */
    virtual void RunEvent(int) { }
    /**
     * Finish up the algorithm. Default: Do nothing. 
     */
    virtual void Finish(void) { }
    ClassDef(Algorithm, 1)
  };

  /**
   * A minimal algorithm that does nothing.
   */
  class NullAlgorithm: public pamela::Algorithm {
  public:
    NullAlgorithm(const pamela::PacketType *);
    virtual std::string GetVersionInfo(void) const = 0;
    ClassDef(NullAlgorithm, 1)
  };

}

#endif /* ALGORITHM_H */
