
// Implementation of the TestTofReader class.
 

#include <string>
#include <log4cxx/logger.h>
extern "C" {
    #include "CRC.h"
}
#include <fstream>
#include "ReaderAlgorithms.h"


using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.TestTofReader"));

/**
 * Constructor. 
 */
TestTofReader::TestTofReader(void): 
  TechmodelAlgorithm(PacketType::TestTof, "TechmodelTestTofReader") { 
  logger->debug(_T("Constructor"));
  testTof = new TestTofEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string TestTofReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/TestTofReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void TestTofReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &testTof, testTof->Class());
  logger->debug(_T("Initialize"));
}

/**
 * Unpack the TestTof event from an input file.
 */
void TestTofReader::RunEvent(int EventNumber, long int length) throw (Exception){
    
    
}

