#ifndef PAMVMC_DET_TOF_S3_H
#define PAMVMC_DET_TOF_S3_H

#include "PamVMCDetector.h"

#include "PamVMCTofSD.h"

class PamVMCTofSD;

class PamVMCDetTofS3  : public PamVMCDetector {

 public:


   PamVMCDetTofS3():PamVMCDetector("S3") 
  {;   };
 
  
  void DefineGeometry();

  void DefineCuts();

  virtual void InitMC(){

    TString t = "S31Y";
    PamVMCTofSD *s31y = new PamVMCTofSD("S31Y");
    fdetSD.Add(new TObjString(t), s31y);
    PamVMCSDMgr::Instance()->SetSD("S31Y",s31y);

    t = "S32X";
    PamVMCTofSD *s32x = new PamVMCTofSD("S32X");
    fdetSD.Add(new TObjString(t), s32x);
    PamVMCSDMgr::Instance()->SetSD("S32X",s32x);
  }

  ClassDef(PamVMCDetTofS3,1)
};


#endif //PAMVMC_DET_TOF_S3_H
