#ifndef PAMVMCTOFID_H
#define PAMVMCTOFID_H
#include <iostream>
#include "TVirtualMC.h"
#include "pGeoID.h"

#define TOFOF 1

using std::cout;
using std::endl;

struct pTofID: public pGeoID {
  Int_t plNo;
 

  pTofID(): plNo(-1) {};
  pTofID(Int_t offset): pGeoID(offset), plNo(-1) {};
  pTofID & operator = (const pTofID &pid) {
    plNo=pid.plNo;
    return *this;
  }

  Bool_t FillVolID(){
    Bool_t t=kFALSE;
    if(gMC) {
      	gMC->CurrentVolOffID(1,plNo);
      	t= kTRUE;
    }
    return t;
  }

  Int_t GetID() const { return plNo; }

  void Print(const Option_t* ="") const { 
    cout << " pTofID : plNo " << plNo <<endl;
  }

};


#endif // PAMVMCTofID_H
