#include "PamVMCDetPamela.h"

ClassImp(PamVMCDetPamela)

void  PamVMCDetPamela::DefineMother(){

  TGeoMaterial *m =0;
  TString s = "N2GAS";
  m = GetMat(s);
  if (!m){
    m = new TGeoMaterial(s,14.01,7,0.1250000E-02);
    m->SetUniqueID( 19);
   }
  TGeoMedium *n = 0;
  s = "N2 GAS";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,3,19,-1,1,40,1,0.5000000E-01,0.5000000E-01,0.1000000E-02,0.5000000E-03);

  TGeoVolume *v = 0;

  s = "PAME";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeTube(s,GetMed("N2 GAS"),0.,120.,130.);
  gGeoManager->SetTopVolume(v);

};

void  PamVMCDetPamela::DefineShell(){

  TGeoMaterial *m = 0;
  TGeoMixture *x = 0;
  TString s = "ALUMINIUM";
  m = GetMat(s);
  if(!m){
    m = new TGeoMaterial(s,26.98,13,2.7);
    m->SetUniqueID( 9);
   }

  s = "MYLAR";
  x = (TGeoMixture*) GetMat(s);
  if(!x){
    x = new TGeoMixture(s,3,   1.39000    );
    x->SetUniqueID( 29);
    x->DefineElement(0,12.011,6,0.6250159);
    x->DefineElement(1,1.00794,1,0.4196011E-01);
    x->DefineElement(2,15.9994,8,0.3330241);
  }

  s = "NYLON6";
  x = (TGeoMixture*)GetMat(s);
  if(!x){
    x = new TGeoMixture(s,4,   1.14000    );
    x->SetUniqueID(  35);
    x->DefineElement(0,12.011,6,0.6368534);
    x->DefineElement(1,1.00794,1,0.9797978E-01);
    x->DefineElement(2,15.9994,8,0.1413881);
    x->DefineElement(3,14.00674,7,0.1237788);
  }

  s = "AMG6M";
  x = (TGeoMixture*)GetMat(s);
  if(!x){
    x = new TGeoMixture(s,2,   2.61000    );
    x->SetUniqueID(  36);
    x->DefineElement(0,26.9815,13,0.94);
    x->DefineElement(1,24.305,12,0.6000000E-01);
   }

  TGeoMedium *n = 0;


  s = "ALUMINIUM";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,1,9,-1,1,40,1,100,0.5000000E-01,0.136283,0.5000000E-03);

  s = "MYLAR";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,19,29,-1,1,40,1,100,0.5000000E-01,0.2300000E-04,0.5000000E-03);
  
  s = "Nylon6 Mixture";
  n = (GetMed(s))?GetMed(s):  new TGeoMedium(s,25,35,-1,1,40,1,0.5000000E-01,0.5000000E-01,0.1495361E-04,0.5000000E-03);
  
  s = "AMg6M Mixture";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,26,36,-1,1,40,1,0.5000000E-01,0.5000000E-01,0.1699982E-02,0.5000000E-03);
  

  TGeoVolume *v = 0;

  s = "SHEL";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeCone(s,GetMed("ALUMINIUM"),38.8717,52.5,52.651,43.6423,43.7932);
  s = "TSPH";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeSphere(s,GetMed("AMg6M Mixture"),240.,240.17,0.,10.5062,0.,360.);
  s = "COV1";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeSphere(s,GetMed("Nylon6 Mixture"),240.17,240.1715,0.,10.5062,0.,360.);
  s = "COV2";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeSphere(s,GetMed("MYLAR"),240.1715,240.2165,0.,10.5062,0.,360.);
  s = "COV3";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeSphere(s,GetMed("ALUMINIUM"),240.2165,240.2315,0.,10.5062,0.,360.);
  s = "MSHE";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeTube(s,GetMed("ALUMINIUM"),52.5,52.75,19.95);
  s = "BSPH";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeSphere(s,GetMed("ALUMINIUM"),52.5,52.75,90.,180.,0.,360.);

  gGeoManager->GetTopVolume()->AddNodeOverlap(GetVol("SHEL"),1,new TGeoTranslation(0.,0.,66.5559)); //66.5607 Idid it because I need to check... This volume overlaps with TSPH and COV1
  SetMotherProp(GetVol("TSPH"),1,new TGeoTranslation(0.,0.,-130.716)); 
  SetMotherProp(GetVol("COV1"),1,new TGeoTranslation(0.,0.,-130.716)); //-130.7112
  SetMotherProp(GetVol("COV2"),1,new TGeoTranslation(0.,0.,-130.716));
  SetMotherProp(GetVol("COV3"),1,new TGeoTranslation(0.,0.,-130.716));
  SetMotherProp(GetVol("MSHE"),1,new TGeoTranslation(0.,0.,7.7342)); //7.739
  SetMotherProp(GetVol("BSPH"),1,new TGeoTranslation(0.,0.,-12.2158));//-12.211

};

void  PamVMCDetPamela::DefineCuts(){

  TString  s ="ALUMINIUM"; // default GPAMELA parameters
  if (GetMed(s) && !GetCC(s)) 
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
			     0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));
  s ="N2 GAS";
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
                             0.001, 0.01, 1., 1., 1., 0., 0., 1., 1., 4., 1., 1., 2., 1.));
  s ="MYLAR";
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
                             0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));
  s ="Nylon6 Mixture"; 
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
                             0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));
  s ="AMg6M Mixture"; 
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
                             0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));
 
}


