#include "PamVMCDetS4.h"

ClassImp(PamVMCDetS4)

void  PamVMCDetS4::DefineGeometry(){

 TGeoMaterial *m=0;
 TGeoMixture *x=0;
  TString s = "ALUMINIUM"; 
  m = GetMat(s);
  if(!m){
    m = new TGeoMaterial(s,26.98,13,2.7);
    m->SetUniqueID(   9);
  }


 s = "SCINT";
  x = (TGeoMixture*)GetMat(s);  
  if(!x){
    x = new TGeoMixture(s,2,   1.03200    );
    x->SetUniqueID(  17);
    x->DefineElement(0,12.01,6,0.922427);
    x->DefineElement(1,1.01,1,0.7757296E-01);
  }

  TGeoMedium *n=0;

  s="ALUMINIUM";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,1,9,-1,1,40,1,100,0.5000000E-01,0.136283,0.5000000E-03);

  s = "SCINTILLATOR";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,10,17,1,1,40,1,0.5000000E-01,0.5000000E-01,0.1000000E-01,0.5000000E-03);

  TGeoVolume *v = 0;

  s = "S4AL";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("ALUMINIUM"),24.2,24.2,0.6);
  s = "S4";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("SCINTILLATOR"),24.1,24.1,0.5);


  GetVol("S4AL")->AddNode(GetVol("S4"),1,gGeoIdentity);

  SetMotherProp(GetVol("S4AL"),1,new TGeoTranslation(0.,0.,1.811));

};

void  PamVMCDetS4::DefineCuts(){

 TString  s ="ALUMINIUM"; // default GPAMELA parameters
  if (GetMed(s) && !GetCC(s))
  SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
			     0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));
  s ="N2 GAS";
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
                             0.001, 0.01, 1., 1., 1., 0., 0., 1., 1., 4., 1., 1., 2., 1.));
}

