#include "PamVMCDetND.h"
#include <TGeoMaterial.h>
ClassImp(PamVMCDetND)

void  PamVMCDetND::DefineGeometry(){


 TGeoMaterial *m=0;
 TGeoMixture *x=0;
  TString s = "ALUMINIUM"; 
  m = GetMat(s);
  if(!m){
    m = new TGeoMaterial(s,26.98,13,2.7);
    m->SetUniqueID(   9);
  }

  s = "IRON";
  m = GetMat(s);
  if(!m){
    m = new TGeoMaterial(s,55.85,26,7.87);
    m->SetUniqueID(  10);
  }

  s = "N2GAS";
  m = GetMat(s);
  if (!m){
    m = new TGeoMaterial(s,14.01,7,0.1250000E-02);
    m->SetUniqueID(  19);
  }


  s = "CADMIUM";
  m = GetMat(s);
  if(!m){
    m = new TGeoMaterial(s,112.411,48,8.65);
    m->SetUniqueID(  31);
  }

  s = "He3";
  m = GetMat(s);
  if(!m){
    // m = new TGeoMaterial(s,3,2,0.1246000E-02);
    m = new TGeoMaterial(s,3,2,0.1246e-2);
    // m->SetState(TGeoMaterial::EGeoMaterialState(3));
    //m->SetPressure(7*STP_pressure);
    m->SetUniqueID(  33);
  }

  s = "POLYETHYLENE";
  x = (TGeoMixture*)GetMat(s);
  if(!x){
    x = new TGeoMixture(s,2,  0.930000    );
    x->SetUniqueID(  34);
    x->DefineElement(0,12.011,6,0.8562844);
    x->DefineElement(1,1.00794,1,0.1437155);
  }

  TGeoMedium *n =0;

  s="ALUMINIUM";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,1,9,-1,1,40,1,100,0.5000000E-01,0.136283,0.5000000E-03);

  s = "N2 GAS";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,3,19,-1,1,40,1,0.5000000E-01,0.5000000E-01,0.1000000E-02,0.5000000E-03);

  s = "IRON";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,27,10,-1,1,40,1,100,0.5000000E-01,0.2491200E-02,0.5000000E-03); 
  
  s = "CADMIUM";
  n = (GetMed(s))?GetMed(s):  new TGeoMedium(s,21,31,-1,1,40,1,0.5000000E-01,0.5000000E-01,0.5000000E-03,0.5000000E-03);
  
  s = "He3";
  n = (GetMed(s))?GetMed(s):  new TGeoMedium(s,22,33,-1,1,40,1,0.5000000E-01,0.5000000E-01,0.1840000E-01,0.5000000E-03);
  
  s = "POLYETHYLENE";
  n = (GetMed(s))?GetMed(s):  new TGeoMedium(s,23,34,-1,1,40,1,100,0.5000000E-01,0.2000000E-01,0.5000000E-03);

  TGeoVolume *v = 0;

  s = "NDBO";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("N2 GAS"),27.5,30.,7.5);
  s = "NDBX";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("ALUMINIUM"),21.45,21.45,7.);
  s = "NDCD";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("CADMIUM"),21.25,21.25,6.9);
  s = "NDBI";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("N2 GAS"),21.2,21.2,6.875);
  s = "NDTU";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeTube(s,GetMed("IRON"),0.,0.925,10.); // orig (s,GetMed("IRON"),0.92,0.925,10)
  s = "NDTI";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeTube(s,GetMed("He3"),0.,0.92,9.99); // orig (s,GetMed("He3"),0,0.92,10)
  s = "NDPB"; 
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("POLYETHYLENE"),21.2,21.2,1.);
  s = "NDCO";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("ALUMINIUM"),27.5,30.,0.5);
  s = "NDBS";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("ALUMINIUM"),15,4.275,7.);
  s = "NDSS";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("N2 GAS"),14.8,4.075,6.8);
  s = "NDCI";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("N2 GAS"),21.2,11.3,0.325);
  s = "NDCM";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("N2 GAS"),21.2,4.25,0.325);
  s = "NDCE";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("N2 GAS"),14.6,2.875,0.325);
  s = "NDSI";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("N2 GAS"),1.,7.26,0.325);
  s = "NDSM";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("N2 GAS"),1.,5.8,0.325);
  s = "NDSE";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("N2 GAS"),4.2,1.05,0.325);


  GetVol("NDBO")->AddNode(GetVol("NDBX"),1,new TGeoTranslation(0.,0.,-0.5));
    GetVol("NDBX")->AddNode(GetVol("NDCD"),1,new TGeoTranslation(0.,0.,0.1));
      GetVol("NDCD")->AddNode(GetVol("NDBI"),1,new TGeoTranslation(0.,0.,0.25E-01));
        GetVol("NDBI")->AddNode(GetVol("NDTU"),1,new TGeoCombiTrans(-19.975,0.,0.5E-01,GetRot("rot2")));//FLUKA off
          GetVol("NDTU")->AddNode(GetVol("NDTI"),1,gGeoIdentity);//FLUKA off
        GetVol("NDBI")->AddNode(GetVol("NDTU"),2,new TGeoCombiTrans(-17.625,0.,0.5E-01,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),3,new TGeoCombiTrans(-15.275,0.,0.5E-01,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),4,new TGeoCombiTrans(-12.925,0.,0.5E-01,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),5,new TGeoCombiTrans(-10.575,0.,0.5E-01,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),6,new TGeoCombiTrans(-8.225,0.,0.5E-01,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),7,new TGeoCombiTrans(-5.875,0.,0.5E-01,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),8,new TGeoCombiTrans(-3.525,0.,0.5E-01,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),9,new TGeoCombiTrans(-1.175,0.,0.5E-01,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),10,new TGeoCombiTrans(1.175,0.,0.5E-01,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),11,new TGeoCombiTrans(3.525,0.,0.5E-01,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),12,new TGeoCombiTrans(5.875,0.,0.5E-01,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),13,new TGeoCombiTrans(8.225,0.,0.5E-01,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),14,new TGeoCombiTrans(10.575,0.,0.5E-01,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),15,new TGeoCombiTrans(12.925,0.,0.5E-01,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),16,new TGeoCombiTrans(15.275,0.,0.5E-01,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),17,new TGeoCombiTrans(17.625,0.,0.5E-01,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),18,new TGeoCombiTrans(19.975,0.,0.5E-01,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),19,new TGeoCombiTrans(-19.975,0.,3.9,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),20,new TGeoCombiTrans(-17.625,0.,3.9,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),21,new TGeoCombiTrans(-15.275,0.,3.9,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),22,new TGeoCombiTrans(-12.925,0.,3.9,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),23,new TGeoCombiTrans(-10.575,0.,3.9,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),24,new TGeoCombiTrans(-8.225,0.,3.9,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),25,new TGeoCombiTrans(-5.875,0.,3.9,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),26,new TGeoCombiTrans(-3.525,0.,3.9,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),27,new TGeoCombiTrans(-1.175,0.,3.9,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),28,new TGeoCombiTrans(1.175,0.,3.9,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),29,new TGeoCombiTrans(3.525,0.,3.9,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),30,new TGeoCombiTrans(5.875,0.,3.9,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),31,new TGeoCombiTrans(8.225,0.,3.9,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),32,new TGeoCombiTrans(10.575,0.,3.9,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),33,new TGeoCombiTrans(12.925,0.,3.9,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),34,new TGeoCombiTrans(15.275,0.,3.9,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),35,new TGeoCombiTrans(17.625,0.,3.9,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDTU"),36,new TGeoCombiTrans(19.975,0.,3.9,GetRot("rot2")));
	GetVol("NDBI")->AddNode(GetVol("NDPB"),1,new TGeoTranslation(0.,0.,-5.875));
	GetVol("NDBI")->AddNode(GetVol("NDPB"),2,new TGeoTranslation(0.,0.,-3.875));
	GetVol("NDBI")->AddNode(GetVol("NDPB"),3,new TGeoTranslation(0.,0.,-1.875));
	GetVol("NDBI")->AddNode(GetVol("NDPB"),4,new TGeoTranslation(0.,0.,1.975));
	GetVol("NDBI")->AddNode(GetVol("NDPB"),5,new TGeoTranslation(0.,0.,5.825));
  GetVol("NDBO")->AddNode(GetVol("NDCO"),1,new TGeoTranslation(0.,0.,7.));
    GetVol("NDCO")->AddNode(GetVol("NDCM"),1,new TGeoTranslation(0.,-16.95,0.175));
    GetVol("NDCO")->AddNode(GetVol("NDCM"),2,new TGeoTranslation(0.,16.95,0.175));
    GetVol("NDCO")->AddNode(GetVol("NDCI"),1,new TGeoTranslation(0.,0.,0.175));
    GetVol("NDCO")->AddNode(GetVol("NDCE"),1,new TGeoTranslation(0.,-25.475,0.175));
    GetVol("NDCO")->AddNode(GetVol("NDCE"),2,new TGeoTranslation(0.,25.475,0.175));
    GetVol("NDCO")->AddNode(GetVol("NDSM"),1,new TGeoTranslation(-23.6,-14.6,0.175));
    GetVol("NDCO")->AddNode(GetVol("NDSM"),2,new TGeoTranslation(23.6,-14.6,0.175));
    GetVol("NDCO")->AddNode(GetVol("NDSM"),3,new TGeoTranslation(-23.6,14.6,0.175));
    GetVol("NDCO")->AddNode(GetVol("NDSM"),4,new TGeoTranslation(23.6,14.6,0.175));
    GetVol("NDCO")->AddNode(GetVol("NDSI"),1,new TGeoTranslation(-23.6,0.,0.175));
    GetVol("NDCO")->AddNode(GetVol("NDSI"),2,new TGeoTranslation(23.6,0.,0.175));
    GetVol("NDCO")->AddNode(GetVol("NDSE"),1,new TGeoTranslation(-20.4,-23.65,0.175));
    GetVol("NDCO")->AddNode(GetVol("NDSE"),2,new TGeoTranslation(20.4,-23.65,0.175));
    GetVol("NDCO")->AddNode(GetVol("NDSE"),3,new TGeoTranslation(-20.4,23.65,0.175));
    GetVol("NDCO")->AddNode(GetVol("NDSE"),4,new TGeoTranslation(20.4,23.65,0.175));
  GetVol("NDBO")->AddNode(GetVol("NDBS"),1,new TGeoTranslation(0.,-25.725,-0.5));
    GetVol("NDBS")->AddNode(GetVol("NDSS"),1,gGeoIdentity);
  GetVol("NDBO")->AddNode(GetVol("NDBS"),2,new TGeoTranslation(0.,25.725,-0.5));


  SetMotherProp(GetVol("NDBO"),1,new TGeoTranslation(0.,0.,-6.289));

};

void  PamVMCDetND::DefineCuts(){

  TString  s ="ALUMINIUM"; // default GPAMELA parameters
  if (GetMed(s) && !GetCC(s))
  SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
			     0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));
  s ="N2 GAS";
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
                             0.001, 0.01, 1., 1., 1., 0., 0., 1., 1., 4., 1., 1., 2., 1.));
  s = "IRON";  //default GPAMELA parameters
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
			     0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));   
  s = "CADMIUM"; //default GPAMELA parameters
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
                             0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));
  s = "He3";
  if (GetMed(s) && !GetCC(s)) //default GPAMELA parameters
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
                             0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));
  s = "POLYETHYLENE"; //default GPAMELA parameters
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
                             0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));
}

