#ifndef PAMVMC_ND_DIG_H
#define PAMVMC_ND_DIG_H

#include "PamVMCDigitizer.h"

#define NTUBES 36


typedef vector <PamVMCDetectorHit*> pHits;

using std::cout;
using std::endl;

class PamVMCNDDig  : public PamVMCDigitizer {

  pHits fpHits; //hits, sorted by time
  vector <Double_t> tauHits [NTUBES]; //array of vectors, conains tau for hits
  pHits tubeHits [NTUBES]; //hits, sorted by time and by tubes
  

Bool_t IsInsideVector(PamVMCDetectorHit* phit){  
    pHits::const_iterator p = fpHits.begin();
    while( p!=fpHits.end() )
      {
	if (phit==(*p)) return kTRUE;
	p++;  
      } 
    return kFALSE;
  }


 public:

  PamVMCNDDig(UInt_t seed):PamVMCDigitizer("ND"){
      rnd = new TRandom3(seed); 
  }

  
  virtual ~PamVMCNDDig(){ ;}

  
  void Digitize();


  ClassDef(PamVMCNDDig,2)
};




#endif //PAMVMC_ND_DIG_H
