#ifndef PAMVMCSQLMGR_H
#define PAMVMCSQLMGR_H
#include <iostream>

#include "GLTables.h"
#include "TString.h"
#include <TSQLServer.h>
#include <TSystem.h>

class PamVMCSQLMgr: public TObject {

 private:
 
  static PamVMCSQLMgr * fsql;
  
  TSQLServer * fdbc;
  GL_TABLES * fglt;
  GL_PARAM * fglparam;
  GL_ROOT * fglroot;
  GL_CALO_CALIB *fglcalo;

  TString fdbhost;
  TString fdbuser;
  TString fdbpsw;

  TString fpathtodata;

 protected:
  PamVMCSQLMgr();

 public:

  ~PamVMCSQLMgr(){ 
    delete fdbc; 
    delete fglt; 
    delete fglparam;
    delete fglroot;
    delete fglcalo;
  }
  
  static PamVMCSQLMgr * Instance();

  TString GetDataPath(){ return fpathtodata; }

  TSQLServer * GetSQL(){ return fdbc; }

  GL_TABLES * GetTAB(){ return fglt; }

  GL_PARAM * GetPAR(){ return fglparam; }
  
  Int_t Query_GL_PARAM(UInt_t time, UInt_t type){

    return fglparam->Query_GL_PARAM(time,type,fdbc);
  }

  GL_ROOT * GetROOT(){ return fglroot; }

  Int_t Query_GL_ROOT(UInt_t id){

    return fglroot->Query_GL_ROOT(id,fdbc);
  }

  GL_CALO_CALIB * GetCaloCalib(){ return fglcalo; }

  Int_t Query_GL_CALO_CALIB(UInt_t time, UInt_t &uptime, 
			    UInt_t section){
    
    return fglcalo->Query_GL_CALO_CALIB(time,uptime,section,fdbc);
  }


};

#endif
