#ifndef PAMVMC_VOL_CROSS_H
#define PAMVMC_VOL_CROSS_H
#include <iostream>
#include <TObject.h>
#include <TString.h>
#include <TObjString.h>
#include <TMap.h>
#include "PamVMCGeoID.h"
#include "PamVMCGeoIDMgr.h"
//#include <TG4G3Units.h>

class PamVMCVolCross  : public TObject {

 protected:

  TString fdname;
  PamVMCGeoID *fdetID;
  
 public:


  PamVMCVolCross(char *dname=""): fdname(dname), fdetID(0)
  {
   fdetID=new PamVMCGeoID(dname);
  }

  
  virtual ~PamVMCVolCross() {  delete fdetID;}
  
  virtual void CrossVol(){
    fdetID->FillVolID(); 
    FillCrossMap();
  }
 
  virtual void FillCrossMap()=0;

  virtual void Reset()=0;

  virtual Bool_t IsVolCross(){ return kFALSE; };



  ClassDef(PamVMCVolCross,1)
};


#endif //PAMVMC_VOL_CROSS_H
