#ifndef PAMG4_RANGE_CUTS_PHYSICS_LIST_H
#define PAMG4_RANGE_CUTS_PHYSICS_LIST_H


#include "TG4Verbose.h"

#include <G4VModularPhysicsList.hh>
#include "TG4Globals.h"


class PamG4RangeCutsPhysicsList: public G4VModularPhysicsList,
                             public TG4Verbose
{
  public:
    PamG4RangeCutsPhysicsList();
    virtual ~PamG4RangeCutsPhysicsList();
  
    // static methods
    static PamG4RangeCutsPhysicsList* Instance();
      
    // methods
    virtual void ConstructProcess();
                  /// No cuts are set here
    virtual void SetCuts() {}

    virtual void Configure();

    virtual G4int VerboseLevel() const;
    virtual void  VerboseLevel(G4int level);

   
  private:   
        
    // static data members
    static PamG4RangeCutsPhysicsList*  fgInstance; ///< this instance


};
// inline methods

inline PamG4RangeCutsPhysicsList* PamG4RangeCutsPhysicsList::Instance() { 
  /// Return this instance
  return fgInstance; 
}  

#endif //PAMG4_RANGE_CUTS_PHYSICS_LIST_H

