// $Id: run_g4.C,v 1.0 2007/06/01 
//
// Macro for running G4PAM_VMC with Geant4. 
void run_g4_test(const TString& configMacro = "g4Config.C") {

    // Load basic libraries
    gROOT->LoadMacro("./macro/basiclibs.C");
    basiclibs();

    // Load PAMELA libs
    TString PAMLIB=gSystem->Getenv("PAM_LIB");
    gSystem->Load(PAMLIB+"/libyoda.so");
    gSystem->Load(PAMLIB+"/libDarthVader.so");
    gSystem->Load(PAMLIB+"/libPamLevel2.so");
    
    // Load Geant4 libraries
    
    gROOT->LoadMacro("./macro/PamG4Libs.C");
    PamG4Libs();
    
    // Load this example libraries
    TString G4WD=gSystem->Getenv("G4WORKDIR");
    TString PLAT=gSystem->Getenv("PLATFORM");
    gSystem->Load(G4WD+"/lib/tgt_"+PLAT+"/libPamVMC_fc");
    
    // MC application
    PamVMCApplication* appl 
      = new PamVMCApplication("PAMG4_VMC", "PAMELA GEANT4 VMC application");
   
    appl->GetPrimaryGenerator()->SetNofPrimaries(1);  
     
    
    // Initialize MC
    appl->InitMC(configMacro);
    ((TGeant4*)gMC)->ProcessGeantMacro("g4config2.in");

#define EVENTS 5000  
  
#define RMIN 1.0
#define RMAX 2.0

#define X0  0.
#define Y0  0.
#define Z0 110.

#define DX   10.0
#define DY   10.0

#define PX  0.
#define PY  0.
    //#define PEEE  -1.
   
#define DPX 0.1
#define DPY 0.1
#define DPZ 0.1
 
    TRandom3 r(123456);
    TRandom3 dprx(123);
    TRandom3 dpry(456);
    TRandom3 dprz(321);
    TRandom3 drx(132);
    TRandom3 dry(465);
    
    for (Int_t i=0; i<EVENTS; i++){
      Double_t rig = r.Uniform(RMIN,RMAX);
      appl->GetPrimaryGenerator()->SetRigidity(rig);

      Double_t dpx = dprx.Uniform(-DPX,DPX);
      Double_t dpy = dpry.Uniform(-DPY,DPY);
      Double_t dpz = dprz.Uniform(-DPZ,DPZ);
      appl->GetPrimaryGenerator()->SetDirection(PX+dpx,PY+dpy,-1.0+dpz);
      
      Double_t dx = drx.Uniform(-DX,DX);
      Double_t dy = dry.Uniform(-DY,DY);
      
      appl->GetPrimaryGenerator()->SetPosition(X0+dx,Y0+dy,Z0);
      appl->RunMC(1);
    }
   
   // Visualization settings
    // ((TGeant4*)gMC)->ProcessGeantMacro("g4vis.in");
    
    // Run MC
    //  appl->RunMC(1000);
     appl->FinishRun();
     // ((TGeant4*)gMC)->StartGeantUI();
     //  delete appl;

  }  
