#ifndef PAMVMCCUTCONTMGR_H
#define PAMVMCCUTCONTMGR_H
#include <iostream>

#include "TString.h"
#include "TObjString.h"
#include "TMap.h"
#include "TVirtualMC.h"
#include "pCutControl.h"


class PamVMCCutContMgr: public TObject {

 private:

  static PamVMCCutContMgr * fcutcont;
  TMap fcutcontmap;

 protected:
  ~PamVMCCutContMgr() {fcutcontmap.DeleteAll();};

 public:
  
  static PamVMCCutContMgr * Instance();

  pCutControl *  GetCutCont(const char *medname){
    return  (pCutControl*)fcutcontmap(medname);
  }

  void SetCutCont(const char *medname, pCutControl * pCC){
    fcutcontmap.Add(new TObjString(medname),pCC);
  }

void SetCuts(){
   TMapIter *n= (TMapIter *)fcutcontmap.MakeIterator();
   TObject *o; while( o=(TObject *) n->Next()) {
    
      ((pCutControl*)fcutcontmap.GetValue(o))->SetCuts();
      
       }
}

void Print(const Option_t* ="") const{

    std::cout<<"LIST OF CUTS AND CONTROLS FOR REGISTERED MEDIA"<<std::endl;
    TMapIter *n= (TMapIter *)fcutcontmap.MakeIterator();
    TObject *o; while( o=(TObject *) n->Next()) {
      TString medname =(*(TObjString*)o).GetString();
      std::cout<<"MEDIA: "<<medname<<std::endl;
      ((pCutControl*)fcutcontmap.GetValue(o))->Print();  
   }
}
  
};
#endif
