// $Id: run_g4.C,v 1.0 2007/06/01 
//
// Macro for running G4PAM_VMC with 
class TGeant3; 

void run_g3(const TString& configMacro = "g3Config.C") 
{
  // Load basic libraries
  gROOT->LoadMacro("./macro/basiclibs.C");
  basiclibs();

  // Load PAMELA libs
   TString PAMLIB=gSystem->Getenv("PAM_LIB");
   gSystem->Load(PAMLIB+"/libyoda.so");
   gSystem->Load(PAMLIB+"/libDarthVader.so");
   gSystem->Load(PAMLIB+"/libPamLevel2.so");

  // Load Geant4 libraries
  
  //  gROOT->LoadMacro("./macro/PamG4Libs.C");
  //PamG4Libs();

  // Load this example libraries
  TString G4WD=gSystem->Getenv("G4WORKDIR");
  TString PLAT=gSystem->Getenv("PLATFORM");
   gSystem->Load(G4WD+"/lib/tgt_"+PLAT+"/libPamVMC_fc");

  // MC application
  PamVMCApplication* appl 
    = new PamVMCApplication("PAMFLUKA_VMC", "PAMELA GEANT4 VMC application");
    
   gSystem->Load("/home/nikolas/francesco/aliroot/pro/geant3/lib/tgt_linux/libgeant321");
   new TGeant3TGeo("pamg3",0);
   //   gMC->Init();
//    appl->GetPrimaryGenerator()->SetNofPrimaries(1);  
   appl->SetVerboseLevel(4);  
//    appl->ConstructGeometry();
  // Macro to run with primary = polarized optical photon
  //gROOT->LoadMacro("optPhoton.C");
  //optPhoton();  

  // Initialize MC
   appl->InitMC(configMacro);
  
  // Customise Geant4 setting after initialization:
  // Physics list
      //  ((TGeant4*)gMC)->ProcessGeantMacro("g4config2.in");
  // Visualization settings
  // ((TGeant4*)gMC)->ProcessGeantMacro("g4vis.in");

  // Run MC
   appl->RunMC(1);

      //  delete appl;

   // return 

}  
