// $Id: run_g4.C,v 1.0 2007/06/01 
//
// Macro for running G4PAM_VMC with 
class TFluka; 

void run_fluka(const TString& configMacro = "flukaConfig.C") 
{
  // Load basic libraries
  gROOT->LoadMacro("./macro/basiclibs.C");
  basiclibs();

  // Load PAMELA libs
  TString PAMLIB=gSystem->Getenv("PAM_LIB");
  gSystem->Load(PAMLIB+"/libyoda.so");
  gSystem->Load(PAMLIB+"/libDarthVader.so");
  gSystem->Load(PAMLIB+"/libPamLevel2.so");


  // Load TFluka libraries
  gSystem->Load("/home/nikolas/francesco/vmc/fluka_vmc/lib/tgt_linux/libfluka");  
  // Load this example libraries
  TString G4WD=gSystem->Getenv("G4WORKDIR");
  TString PLAT=gSystem->Getenv("PLATFORM");
  gSystem->Load(G4WD+"/lib/tgt_"+PLAT+"/libPamVMC_fc");

  // MC application
  PamVMCApplication* appl 
    = new PamVMCApplication("PAMFLUKA_VMC", "PAMELA GEANT4 VMC application");
    

    appl->SetVerboseLevel(1);  
 
  
  // Initialize MC
  
  appl->InitMC(configMacro);
  // appl->SetVerboseLevel(1);  
  
  // Run MC
  appl->RunMC(25000);
  appl->FinishRun();
    delete appl;
  
  // return 
  
}  
