#ifndef PAMVMCTRKF77_H
#define PAMVMCTRKF77_H

#define gmtod GMTOD 
#define gdtom GDTOM
#define gufield GUFIELD


#include <iostream>

using std::cout;
using std::endl; 
#include <TGeoManager.h>
#include <TGeoMatrix.h>
#include <TVirtualMC.h>
#include <TRandom.h>
#include "PamVMCFieldMgr.h"
extern "C"{
  void grndm_(Float_t*, Int_t& );
  void gmtod_(Float_t* , Float_t* , Int_t& );
  void gdtom_(Float_t* , Float_t* , Int_t& );
  void gufield_(Float_t*, Float_t*);
 }

void grndm_(Float_t* r, Int_t& n){
  TRandom3 rnd(0);
  for (Int_t i=0; i<n; i++){
    r[i]=rnd.Uniform();
  }
}

void gmtod_(Float_t* a, Float_t* b, Int_t& c){
  Double_t master[3];
  Double_t local[3];

  for (Int_t i=0; i<3; ++i)  master[i] = (Double_t) a[i];
  
  Double_t * m = &master[0];
  Double_t * l = &local[0];
  
  gGeoManager->MasterToLocal(m,l);

  //cout<<"MasterToLocal"<<endl;
  for (Int_t i=0; i<3; ++i){
    //cout<<master[i]<<" "<<local[i]<<endl;
    b[i] = (Float_t)local[i];
  }
  c=c;
}


void gdtom_(Float_t* a, Float_t* b, Int_t& c){
  Double_t master[3];
  Double_t local[3];

  for (Int_t i=0; i<3; ++i) local[i] = (Double_t)a[i];
  
  Double_t * m = &master[0];
  Double_t * l = &local[0];

  gGeoManager->LocalToMaster(l,m);

  //cout<<"LocalToMaster"<<endl;
  for (Int_t i=0; i<3; ++i) {
    //cout<<" "<<local[i]<<" "<<master[i]<<endl;
    b[i] = (Float_t)master[i];
  }
  c=c;
}

void gufield_(Float_t *x, Float_t *b){
  PamVMCFieldMgr::Instance()->Field(x,b);
}
#endif //PamVMCTrkF77.h
