#include "PamVMCVolCrossMgr.h"

#include "PamVMCCrossTOF.h"
#include "PamVMCCrossTRK.h"
#include "PamVMCCrossMAG.h"

PamVMCVolCrossMgr::PamVMCVolCrossMgr(){

  TString t;
  t="S11Y";
  fvolmap.Add(new TObjString(t), new PamVMCCrossS11Y());
  t="S12X";
  fvolmap.Add(new TObjString(t), new PamVMCCrossS12X());
  t="S21X";
  fvolmap.Add(new TObjString(t), new PamVMCCrossS21X());
  t="S22Y";
  fvolmap.Add(new TObjString(t), new PamVMCCrossS22Y());
  t="S31Y";
  fvolmap.Add(new TObjString(t), new PamVMCCrossS31Y());
  t="S32X";
  fvolmap.Add(new TObjString(t), new PamVMCCrossS32X());
  t="TSPA";
  fvolmap.Add(new TObjString(t), new PamVMCCrossTRK());
  t="MGPL";
  fvolmap.Add(new TObjString(t), new PamVMCCrossMGPL());
  t="MGPA";
  fvolmap.Add(new TObjString(t), new PamVMCCrossMGPA());

}

PamVMCVolCrossMgr * PamVMCVolCrossMgr::fcrm = 0;

PamVMCVolCrossMgr * PamVMCVolCrossMgr::Instance(){
  if(fcrm == 0) {
    fcrm = new PamVMCVolCrossMgr();
  }
  return fcrm;
}

Bool_t PamVMCVolCrossMgr::IsTrackGood(){


 Bool_t S11=((PamVMCVolCross*)fvolmap.GetValue("S11Y"))->IsVolCross();
 Bool_t S12=((PamVMCVolCross*)fvolmap.GetValue("S12X"))->IsVolCross();
 Bool_t S1=kFALSE;
 if (S11||S12) S1=kTRUE;
 Bool_t S21=((PamVMCVolCross*)fvolmap.GetValue("S21X"))->IsVolCross();
 Bool_t S22=((PamVMCVolCross*)fvolmap.GetValue("S22Y"))->IsVolCross();
 Bool_t S2=kFALSE;
 if(S21||S22) S2=kTRUE;
 Bool_t S31=((PamVMCVolCross*)fvolmap.GetValue("S31Y"))->IsVolCross();
 Bool_t S32=((PamVMCVolCross*)fvolmap.GetValue("S32X"))->IsVolCross();
 Bool_t S3=kFALSE;
 if(S31||S32) S3=kTRUE;

 Bool_t TOF=((PamVMCVolCross*)fvolmap.GetValue("TSPA"))->IsVolCross();
 Bool_t MGPL=((PamVMCVolCross*)fvolmap.GetValue("MGPL"))->IsVolCross();
 Bool_t MGPA=((PamVMCVolCross*)fvolmap.GetValue("MGPA"))->IsVolCross();


 return S1*S2*S3*TOF*MGPL*MGPA;
}

void PamVMCVolCrossMgr::Reset(){
 TMapIter *n= (TMapIter *)fvolmap.MakeIterator();
 TObject *o; while( o=(TObject *) n->Next()) {   
   ((PamVMCVolCross*)fvolmap.GetValue(o))->Reset();      
 }
}
