// $Id: run_g4.C,v 1.0 2007/06/01 
//
// Macro for running G4PAM_VMC with Geant4. 
void run_g4_testTRK(const TString& configMacro = "g4Config.C") {

    // Load basic libraries
    gROOT->LoadMacro("./macro/basiclibs.C");
    basiclibs();

    // Load PAMELA libs
    TString PAMLIB=gSystem->Getenv("PAM_LIB");
    gSystem->Load(PAMLIB+"/libyoda.so");
    gSystem->Load(PAMLIB+"/libDarthVader.so");
    gSystem->Load(PAMLIB+"/libPamLevel2.so");
    
    // Load Geant4 libraries
    
    gROOT->LoadMacro("./macro/PamG4Libs.C");
    PamG4Libs();
    
    // Load this example libraries
    TString G4WD=gSystem->Getenv("G4WORKDIR");
    TString PLAT=gSystem->Getenv("PLATFORM");
    gSystem->Load(G4WD+"/lib/tgt_"+PLAT+"/libPamVMC_fc");
    
    // MC application
    PamVMCApplication* appl 
      = new PamVMCApplication("PAMG4_VMC", "PAMELA GEANT4 VMC application");
    
    //appl->GetPrimaryGenerator()->SetNofPrimaries(1);  
        appl->SetVerboseLevel(0);
      
    // Macro to run with primary = polarized optical photon
    //gROOT->LoadMacro("optPhoton.C");
    //optPhoton();  
	appl->SetVerboseLevel(2);
    // Initialize MC
    appl->InitMC(configMacro);

    // Customise Geant4 setting after initialization:
    // Physics list
//     gMC->SetCut("CUTGAM", 1.0e-6);
//     gMC->SetCut("BCUTE", 1.0e-6);
//     gMC->SetCut("CUTELE", 1.0e-6);
//     gMC->SetCut("DCUTE", 1.0e-6);
//     gMC->SetCut("CUTNEU", 1.0e-6);
//     gMC->SetCut("CUTHAD", 1.0e-6);
//     gMC->SetCut("CUTMUO", 1.0e-6);
//     gMC->SetCut("DCUTM", 1.0e-6);
//     gMC->SetCut("BCUTM", 1.0e-6);
//     gMC->SetCut("PPCUTM", 1.0e-6);
//     gMC->SetCut("TOFMAX", 1.0e-3);
    
    ((TGeant4*)gMC)->ProcessGeantMacro("g4config2.in");
    // Visualization settings
     ((TGeant4*)gMC)->ProcessGeantMacro("g4vis.in");
 
   ((TGeant4*)gMC)->SetMaxNStep(50000);
   //appl->GetPrimaryGenerator()->SetParticle(1000060120);
    appl->GetPrimaryGenerator()->SetParticle(kElectron);
    //appl->GetPrimaryGenerator()->SetDirection(0.,0.);
     //appl->GetPrimaryGenerator()->SetKinEnergy(10.);
     //appl->GetPrimaryGenerator()->SetRigidity(1.0); //GV 
    //appl->GetPrimaryGenerator()->SetPosition(1.,1.,130.);
    // Run MC
    for (Int_t i=0; i<3; i++){
      cout<<"Event "<<i<<endl;
     appl->GetPrimaryGenerator()->SetKinEnergy(10.);
     if (i==0) appl->GetPrimaryGenerator()->SetKinEnergy(0.01);
       appl->GetPrimaryGenerator()->GenSphDist(120.);
       //appl->GetPrimaryGenerator()->GenSphDist(120.,0.,90.,0.,360.);
      // appl->GetPrimaryGenerator()->GenPosition(-22.4,22.4, -18.5, 18.5, 110.0,110.0);
      //appl->GetPrimaryGenerator()->GenDirection(0.,TMath::Pi()/2.,0.,2*TMath::Pi());
      //appl->GetPrimaryGenerator()->GenSpe(1.,5.,-2.75);
      //  appl->GetPrimaryGenerator()->Print();
      // if (i==9) ((TGeant4*)gMC)->ProcessGeantMacro("g4vis.in");
      appl->RunMC(1);

    }
    
    appl->FinishRun();
    //   ((TGeant4*)gMC)->StartGeantUI();
    delete appl;

  }  
