#include "PamVMCDetTrk.h"

ClassImp(PamVMCDetTrk)

void  PamVMCDetTrk::DefineGeometry(){

  TGeoMaterial *m=0;
  TGeoMixture *x =0;
  TString s = "ALUMINIUM"; 
  m = GetMat(s);
  if(!m){
    m = new TGeoMaterial(s,26.98,13,2.7);
    m->SetUniqueID(   9);
  }

  s = "IRON";
  m = GetMat(s);
  if(!m){
    m = new TGeoMaterial(s,55.85,26,7.87);
    m->SetUniqueID(  10);
  }

  s = "SCINT";
  x = (TGeoMixture*)GetMat(s);  
  if(!x){
    x = new TGeoMixture(s,2,   1.03200    );
    x->SetUniqueID(  17);
    x->DefineElement(0,12.01,6,0.922427);
    x->DefineElement(1,1.01,1,0.7757296E-01);
  }

  s = "N2GAS";
  m = GetMat(s);
  if (!m){
    m = new TGeoMaterial(s,14.01,7,0.1250000E-02);
    m->SetUniqueID(  19);
  }

  s = "SILICON TR";
  m= GetMat(s);
  if(!m){
    m = new TGeoMaterial(s,28.09,14,2.33);
    m->SetUniqueID(  20);
  }

  s = "G10C";
  x = (TGeoMixture*)GetMat(s);
  if(!x){
    x = new TGeoMixture(s,4,   1.70000    );
    x->SetUniqueID(  27);
    x->DefineElement(0,28.09,14,0.53);
    x->DefineElement(1,16,8,0.3);
    x->DefineElement(2,12.01,6,0.15);
    x->DefineElement(3,1.01,1,0.2000000E-01);
  }


  TGeoMedium * n = 0;

  s="ALUMINIUM";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,1,9,-1,1,40,1,100,0.5000000E-01,0.136283,0.5000000E-03);

  s = "N2 GAS";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,3,19,-1,1,40,1,0.5000000E-01,0.5000000E-01,0.1000000E-02,0.5000000E-03);

  s = "IRONTR";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,5,10,-1,1,40,1,0.5000000E-01,0.5000000E-01,0.8000000E-01,0.5000000E-03); 

  s = "CARBON FIBER";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,9,17,-1,1,40,1,0.5000000E-01,0.5000000E-01,0.5000000E-02,0.5000000E-03); //CARBON FIBER MADE FROM SCINTILLATOR???

  s = "SITRACKER";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,12,20,1,1,40,1,0.1000000E-02,0.5000000E-01,0.5000000E-04,0.1569056E-01);

  s = "G10C";
   n = (GetMed(s))?GetMed(s):new TGeoMedium(s,17,27,-1,1,40,1,100,0.5000000E-01,0.1200000E-02,0.5000000E-03);

  TGeoVolume *v = 0;

  s = "SPEB";
  v = (GetVol(s))?GetVol(s):gGeoManager->MakeBox(s,GetMed("N2 GAS"),15.,14.4,22.615);
  s = "MGFR"; 
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("ALUMINIUM"),15.,14.4,4.45);
  s = "MGPL";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("IRONTR"),12.,11.4,4.);
  s = "MGPI"; 
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("N2 GAS"),8.07,6.57,4.);
  s = "TRPB";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("ALUMINIUM"),10.49,12.15,0.365);
  s = "TPAS";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("N2 GAS"),8.2,9.9,0.365);
  s = "TPAI";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("ALUMINIUM"),8.144,1.25,0.5E-01);
  s = "TRSL";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("SITRACKER"),2.6665,3.5,0.15E-01);
  s = "THBP";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("G10C"),2.6665,2.75,0.15E-01);
  s = "TSPA";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("SITRACKER"),2.596,3.413,0.15E-01);
  s = "TRCP";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("CARBON FIBER"),0.35E-01,9.9,0.25);
  s = "TBAL"; 
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("ALUMINIUM"),1.49,2.25,0.365);
  s = "MGPA";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("ALUMINIUM"),8.1,6.6,4.);
  s = "TPGA";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("N2 GAS"),10.29,10.65,0.4E-01);
  s = "TPGI";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("N2 GAS"),8.07,6.57,0.15E-01);
  s = "TPGU";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("N2 GAS"),10.49,12.15,0.1E-01);
  s = "TPGD";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("N2 GAS"),12.,11.4,0.5E-02);
   
  GetVol("SPEB")->AddNode(GetVol("MGFR"),1,new TGeoTranslation(0.,0.,18.165));
  GetVol("MGFR")->AddNode(GetVol("TPGD"),1,new TGeoTranslation(0.,0.,-4.445));
  GetVol("MGFR")->AddNode(GetVol("TPGI"),1,new TGeoTranslation(0.,0.,-4.425));
  GetVol("MGFR")->AddNode(GetVol("MGPL"),1,new TGeoTranslation(0.,0.,-0.41));
  GetVol("MGPL")->AddNode(GetVol("MGPA"),1,gGeoIdentity);
  GetVol("MGPA")->AddNode(GetVol("MGPI"),1,gGeoIdentity);
   GetVol("MGFR")->AddNode(GetVol("TPGI"),2,new TGeoTranslation(0.,0.,3.605));
       GetVol("MGFR")->AddNode(GetVol("TPGA"),1,new TGeoTranslation(0.,-0.75,3.66));
       GetVol("MGFR")->AddNode(GetVol("TRPB"),1,new TGeoTranslation(0.,-2.25,4.065));
    GetVol("TRPB")->AddNode(GetVol("TPAS"),4,new TGeoTranslation(0.,-0.75,0.));
         GetVol("TPAS")->AddNode(GetVol("TRCP"),1,new TGeoTranslation(-8.1075,0.,0.15E-01));
         GetVol("TPAS")->AddNode(GetVol("TRCP"),2,new TGeoTranslation(-2.7025,0.,0.15E-01));
         GetVol("TPAS")->AddNode(GetVol("TRCP"),3,new TGeoTranslation(2.7025,0.,0.15E-01));
         GetVol("TPAS")->AddNode(GetVol("TRCP"),4,new TGeoTranslation(8.1075,0.,0.15E-01));
	 GetVol("TPAS")->AddNode(GetVol("TRSL"),1,new TGeoTranslation(-5.405,6.252,0.15E-01));
	 GetVol("TRSL")->AddNode(GetVol("TSPA"),1,gGeoIdentity);
         GetVol("TPAS")->AddNode(GetVol("TRSL"),2,new TGeoTranslation(0.,6.252,0.15E-01));
         GetVol("TPAS")->AddNode(GetVol("TRSL"),3,new TGeoTranslation(5.405,6.252,0.15E-01));
         GetVol("TPAS")->AddNode(GetVol("TRSL"),4,new TGeoTranslation(-5.405,-0.75,0.15E-01));
         GetVol("TPAS")->AddNode(GetVol("TRSL"),5,new TGeoTranslation(0.,-0.75,0.15E-01));
         GetVol("TPAS")->AddNode(GetVol("TRSL"),6,new TGeoTranslation(5.405,-0.75,0.15E-01));
	 GetVol("TPAS")->AddNode(GetVol("THBP"),1,new TGeoTranslation(-5.405,-7.0015,0.15E-01));
	 GetVol("TPAS")->AddNode(GetVol("THBP"),2,new TGeoTranslation(0.,-7.0015,0.15E-01));
	 GetVol("TPAS")->AddNode(GetVol("THBP"),3,new TGeoTranslation(5.405,-7.0015,0.15E-01));
	 GetVol("TPAS")->AddNode(GetVol("TPAI"),4,new TGeoTranslation(0.,-8.65,0.315));
	 GetVol("MGFR")->AddNode(GetVol("TPGU"),2,new TGeoTranslation(0.,-2.25,4.44));

	 GetVol("SPEB")->AddNode(GetVol("MGFR"),2,new TGeoTranslation(0.,0.,9.265));
	 GetVol("SPEB")->AddNode(GetVol("MGFR"),3,new TGeoTranslation(0.,0.,0.365));
	 GetVol("SPEB")->AddNode(GetVol("MGFR"),4,new TGeoTranslation(0.,0.,-8.535));
	 GetVol("SPEB")->AddNode(GetVol("MGFR"),5,new TGeoTranslation(0.,0.,-17.435));

  GetVol("SPEB")->AddNode(GetVol("TRPB"),2,new TGeoCombiTrans(0.,2.25,-22.25,GetRot("rot10")));
  GetVol("SPEB")->AddNode(GetVol("TBAL"),1,new TGeoTranslation(5.4,-12.15,-22.25));
  GetVol("SPEB")->AddNode(GetVol("TBAL"),2,new TGeoTranslation(-5.4,-12.15,-22.25));


  SetMotherProp(GetVol("SPEB"),1,new TGeoTranslation(0.,0.,49.274));
};

void  PamVMCDetTrk::DefineCuts(){

  TString  s ="ALUMINIUM"; // default GPAMELA parameters
  if (GetMed(s) && !GetCC(s))
  SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
			     0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));
  s ="N2 GAS";
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
                             0.001, 0.01, 1., 1., 1., 0., 0., 1., 1., 4., 1., 1., 2., 1.));
  s = "IRONTR";  // default GPAMELA parameters
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
			     0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));
  s = "CARBON FIBER";  //default GPAMELA parameters
  SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
			     0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));
  s = "SITRACKER";
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.00001, 0.00001, 0.0001, 0.0001, 0.00001, 0.00001,
                             0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 1., 1., 1., 1., 2.));

  s = "G10C";
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.00001, 0.00001, 0.00001, 0.00001, 0.001, 0.001, 0.01, 0.00001,
                             0.00001, 0.01, 1., 1., 1., 0., 1., 1., 1., 1., 1., 1., 1., 2.));
}

