#ifndef PAMVMC_CALO_DIG_H
#define PAMVMC_CALO_DIG_H

#include "PamVMCDigitizer.h"



using std::cout;
using std::endl;

class PamVMCCaloDig  : public PamVMCDigitizer {

  Float_t fCalomip[2][22][96]; // ADC to MIP conversion values
  Float_t fcalped[4][11][96]; // pedestals
  Float_t fcalgood[4][11][96]; // used or not in the common noise calculation
  Float_t fcalthr[4][11][6]; // thresholds
  Float_t fcalrms[4][11][96]; // rms
  Float_t fcalbase[4][11][6]; // baselines (common noise) during calibration
  Float_t fcalvar[4][11][6]; // variance
  Float_t fcstwerr[4]; // status word
  Float_t fcperror[4]; // unpacking error flag

  UShort_t fSecCalo[4];
  UShort_t fSecCaloLength[4];

  TClonesArray * fhc;

  void ClearCaloCalib(Int_t s);

  Int_t CaloLoadCalib(Int_t s,TString calname, UInt_t calibno);

  void DigitizeCALOCALIB();

  void FillCalPedNorm(USBuffer *buff, Int_t sec);
  void FillCalPedBack(USBuffer *buff, Int_t sec);
  void FillCalThrNorm(USBuffer *buff, Int_t sec);
  void FillCalThrBack(USBuffer *buff, Int_t sec); 
  void FillCalRmsNorm(USBuffer *buff, Int_t sec);
  void FillCalRmsBack(USBuffer *buff, Int_t sec); 
  void FillCalBaseVarNorm(USBuffer *buff, Int_t sec);
  void FillCalBaseVarBack(USBuffer *buff, Int_t sec);

  Float_t GetCaloErel(Int_t sec, Int_t plane, Int_t strip);

  void DigitizeCaloRaw();
  void DigitizeCaloCompress();
  void DigitizeCaloFull();

 public:

  PamVMCCaloDig(UInt_t seed):PamVMCDigitizer("Calo"){rnd = new TRandom3(seed); }

  
  virtual ~PamVMCCaloDig(){ if(fhc) delete fhc;}


  void LoadCalib();
  
  void Digitize();
  


  ClassDef(PamVMCCaloDig,2)
};


#endif //PAMVMC_CALO_DIG_H
