#include <iostream>

#include "PamVMCDetectorHit.h"
#include <TLorentzVector.h>

using std::cout;
using std::endl;

ClassImp(pHitData)
ClassImp(PamVMCDetectorHit)

pHitData & operator+=( pHitData &a, const pHitData & p) {
    a.fPOS = p.fPOS;
    a.fPDG = p.fPDG;
    a.fPATH= p.fPATH;
    a.fTOF= p.fTOF;
    a.fPIN += p.fPIN;
    a.fXOUT= p.fXOUT;
    a.fYOUT=  p.fYOUT;
    a.fZOUT= p.fZOUT;
    a.fEREL +=  p.fEREL;
    a.fXIN = p.fXIN;
    a.fYIN =  p.fYIN;
    a.fZIN =  p.fZIN;
    return a;
    //    return *this;
}

PamVMCDetectorHit::PamVMCDetectorHit() 
  : TObject(),
    fnocall(0)
   
{
}

PamVMCDetectorHit::~PamVMCDetectorHit() 
{
  // Delete &fhitdata;  
}

void PamVMCDetectorHit::Print(Option_t* /*option*/) const
{
  // Prints hit info
  cout <<"Actual Hit :"<<endl 
       <<" Energy deposit (keV): " << fhitdata.fEREL * 1.0e06 << endl
       <<" Time of flight (us): " << fhitdata.fTOF*1.0e6 <<endl;
}

void PamVMCDetectorHit::Reset()
{
  // Reset all accounted values.
    fhitdata.Clean();
    fnocall=0;
      
}

void PamVMCDetectorHit::operator += ( const PamVMCDetectorHit & p )
{ 
  fhitdata+=p.fhitdata; 
} 

void PamVMCDetectorHit::operator = ( const PamVMCDetectorHit & p )
{ 
  fhitdata=p.fhitdata; 
} 
