// $Id: PamVMCApplication.h,v 1.0 2007/06/01
// 
// Class PamVMCApplication
// ----------------------- 
// Implementation of the TVirtualMCApplication

#define PAMFIELD 1

#ifndef PAMVMC_APPLICATION_H
#define PAMVMC_APPLICATION_H

#include <TVirtualMCApplication.h>
#include "TMCVerbose.h"

#include "PamVMCDetectorSD.h"

#include "PamVMCDetector.h"
#include "PamVMCDetPamela.h"

#include "PamRootManager.h"
#include "PamVMCDetectorHit.h"
#include <TMap.h>

//#include "PamVMCDetector.h"

#ifdef PAMFIELD
#include "TrkParams.h"
#endif

//class PamVMCDetector;

class PamVMCStack;
//class PamVMCDetectorConstruction;
class PamVMCPrimaryGenerator;


class PamVMCDetPamela;

class PamVMCApplication : public TVirtualMCApplication
{
  public:
    PamVMCApplication(const char* name,  const char *title, const char *filename, UInt_t seed);
    PamVMCApplication();
    virtual ~PamVMCApplication();
  
    // static access method
    static PamVMCApplication* Instance(); 

    // methods
    void InitMC(const char *setup, const char *filename, UInt_t seed);
    void RunMC(Int_t nofEvents);
    void AddIons();

    virtual void ConstructGeometry();
    virtual void InitGeometry();
    virtual void GeneratePrimaries();
    virtual void BeginEvent();
    virtual void BeginPrimary();
    virtual void PreTrack();
    virtual void Stepping();
    virtual void PostTrack();
    virtual void FinishPrimary();
    virtual void FinishEvent();
    virtual void FinishRun();
    virtual void Field(const Double_t* x, Double_t* b) const;
    
    // set methods
    void  SetVerboseLevel(Int_t verboseLevel);
 
    // get methods
    PamVMCPrimaryGenerator*  GetPrimaryGenerator() const;

 
 
  private:


    // data members
    Int_t                     fEventNo;
    TMCVerbose                fVerbose;
    PamVMCStack*              fStack;
    PamVMCDetPamela       *fdetector;
    PamVMCPrimaryGenerator*     fPrimaryGenerator;
    PamRootManager             fRootManager;
 
    fin fdstatus;

  

  


#ifdef PAMFIELD
    //    TrkLevel2 pamfield;
#endif
  ClassDef(PamVMCApplication,3)  //Interface to MonteCarlo application
};

// inline functions

inline PamVMCApplication* PamVMCApplication::Instance()
{ return (PamVMCApplication*)(TVirtualMCApplication::Instance()); }

inline void  PamVMCApplication::SetVerboseLevel(Int_t verboseLevel)
{ fVerbose.SetLevel(verboseLevel); }

inline PamVMCPrimaryGenerator*  PamVMCApplication::GetPrimaryGenerator() const
{ return fPrimaryGenerator; }



#endif //PAMVMC_APPLICATION_H

