#include <TG4ComposedPhysicsList.h>
#include "PamG4RunConfiguration.h"
#include <TG4EmPhysicsList.h>
#include <TG4HadronPhysicsList.h>
#include <TG4OpticalPhysicsList.h>
#include <TG4SpecialPhysicsList.h>
#include <TG4Globals.h>


#include "PamG4RangeCutsPhysicsList.h"
ClassImp(PamG4RunConfiguration)


PamG4RunConfiguration::PamG4RunConfiguration(const TString& userGeometry,
					     const TString& physicsList,
                                             const TString& specialProcess)
  : TG4RunConfiguration(userGeometry, physicsList, specialProcess) 
{
  
}


PamG4RunConfiguration::~PamG4RunConfiguration()
{
/// Destructor
}


G4VUserPhysicsList* PamG4RunConfiguration::CreatePhysicsList()
{
// Create default Geant4 VMC physics list

  TG4ComposedPhysicsList* builder = new TG4ComposedPhysicsList();
  
  TString token1 = TG4Globals::GetToken(0, fPhysicsListSelection);
  TString token2 = TG4Globals::GetToken(1, fPhysicsListSelection);
  
  if ( token1 == "emStandard" ) {
  G4cout << "Adding EMPhysicsList" << G4endl;
  builder->AddPhysicsList(new TG4EmPhysicsList());
}  
else {
  G4cout << "Adding HadronPhysicsList " << token1.Data() << G4endl;
  builder->AddPhysicsList(new TG4HadronPhysicsList(token1.Data()));
}  
  
if ( token2 == "optical" ) {
  G4cout << "Adding OpticalPhysicsList " << G4endl;
  builder->AddPhysicsList(new TG4OpticalPhysicsList());
}  
  
 // add option here
  G4cout << "Adding SpecialPhysicsList " << G4endl;
  builder->AddPhysicsList(new TG4SpecialPhysicsList(
                               fSpecialProcessSelection.Data()));

  /*R G4cout << "Adding Range Cuts PhysicsList " << G4endl;
  builder->AddPhysicsList(new PamG4RangeCutsPhysicsList());*/

return builder;  
}  
