#ifndef PAMVMCGEOIDMGR_H
#define PAMVMCGEOIDMGR_H
#include <iostream>

#include "TString.h"
#include "TObjString.h"
#include "TMap.h"

#include "PamVMCCaloID.h"
#include "PamVMCTofID.h"
#include "PamVMCTrkID.h"
#include "PamVMCCardID.h"
#include "PamVMCCasID.h"
#include "PamVMCCatID.h"
#include "PamVMCS4ID.h"
#include "PamVMCNDID.h"

using std::cout;
using std::endl;

struct pGeoID;


class PamVMCGeoIDMgr: public TObject {

 private:

  static PamVMCGeoIDMgr * fgeoid;
  TMap fdmap;

 protected:
  PamVMCGeoIDMgr();

 public:

  ~PamVMCGeoIDMgr(){ fdmap.DeleteAll(); }  

  static PamVMCGeoIDMgr * Instance();
  pGeoID * GetGeoID(const char *name);

  void Print( const Option_t* ="") const { 
    cout << "PamVMCGeoIDMgr, list of pGeoID stored " << endl;
    fdmap.Print();
  }

};

#endif
