#include "PamVMCDetTofS1.h"

ClassImp(PamVMCDetTofS1)

void  PamVMCDetTofS1::DefineGeometry(){

  TGeoMaterial *m=0;
  TGeoMixture *x=0;
  TString s = "ALUMINIUM"; 
  m = GetMat(s);
  if(!m){
    m = new TGeoMaterial(s,26.98,13,2.7);
    m->SetUniqueID(   9);
  }

  s = "SCINT";
  x = (TGeoMixture*)GetMat(s);  
  if(!x){
    x = new TGeoMixture(s,2,   1.03200    );
    x->SetUniqueID(  17);
    x->DefineElement(0,12.01,6,0.922427);
    x->DefineElement(1,1.01,1,0.7757296E-01);
  }

  s = "N2GAS";
  m = GetMat(s);
  if (!m){
    m = new TGeoMaterial(s,14.01,7,0.1250000E-02);
    m->SetUniqueID(  19);
  }
  
  s = "MYLAR";
  x = (TGeoMixture*)GetMat(s);
  if(!x){
    x = new TGeoMixture(s,3,   1.39000    );
    x->SetUniqueID(  29);
    x->DefineElement(0,12.011,6,0.6250159);
    x->DefineElement(1,1.00794,1,0.4196011E-01);
    x->DefineElement(2,15.9994,8,0.3330241);
  }

  s = "POLYSTYRENE";
  x = (TGeoMixture*)GetMat(s);
  if(!x){
    x = new TGeoMixture(s,2,  0.350000E-01);
    x->SetUniqueID(  30);
    x->DefineElement(0,12.011,6,0.9225789);
    x->DefineElement(1,1.00794,1,0.7742105E-01);
  }

  TGeoMedium *n=0;

  s="ALUMINIUM";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,1,9,-1,1,40,1,100,0.5000000E-01,0.136283,0.5000000E-03);

  s = "N2 GAS";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,3,19,-1,1,40,1,0.5000000E-01,0.5000000E-01,0.1000000E-02,0.5000000E-03);

  s = "SCINTILLATOR";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,10,17,1,1,40,1,0.5000000E-01,0.5000000E-01,0.1000000E-01,0.5000000E-03);

  s = "MYLAR";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,19,29,-1,1,40,1,100,0.5000000E-01,0.2300000E-04,0.5000000E-03);

  s = "POLYSTYRENE";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,20,30,-1,1,40,1,100,0.5000000E-01,0.4000000E-02,0.5000000E-03);

  TGeoVolume *v=0;

  s = "S1";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("ALUMINIUM"),20.4184,16.5138,1.3976); 
  s = "S1A";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("N2 GAS"),20.4184,16.5138,1.3646);
  s = "S11M";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("MYLAR"),2.5523,16.5,0.3523);
  s = "S12M";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("MYLAR"),20.4,2.7523,0.3523);
  s = "S11Y";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("SCINTILLATOR"),2.55,16.5,0.35);
  s = "S12X";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("SCINTILLATOR"),20.4,2.75,0.35);
  s = "POL1";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("POLYSTYRENE"),20.4184,16.5138,0.45);
  s = "POL2";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("POLYSTYRENE"),20.4184,16.5138,0.2);

  GetVol("S1")->AddNode(GetVol("S1A"),0,gGeoIdentity);
    GetVol("S1A")->AddNode(GetVol("POL2"),1,new TGeoTranslation(0.,0.,-1.1546));
    GetVol("S1A")->AddNode(GetVol("S12M"),1,new TGeoTranslation(0.,-13.7615,-0.6023));
      GetVol("S12M")->AddNode(GetVol("S12X"),1,gGeoIdentity);
    GetVol("S1A")->AddNode(GetVol("S12M"),2,new TGeoTranslation(0.,-8.2569,-0.6023));
    GetVol("S1A")->AddNode(GetVol("S12M"),3,new TGeoTranslation(0.,-2.7523,-0.6023));
    GetVol("S1A")->AddNode(GetVol("S12M"),4,new TGeoTranslation(0.,2.7523,-0.6023));
    GetVol("S1A")->AddNode(GetVol("S12M"),5,new TGeoTranslation(0.,8.2569,-0.6023));
    GetVol("S1A")->AddNode(GetVol("S12M"),6,new TGeoTranslation(0.,13.7615,-0.6023));
    GetVol("S1A")->AddNode(GetVol("S11M"),1,new TGeoTranslation(-17.8661,0.,0.1023));
      GetVol("S11M")->AddNode(GetVol("S11Y"),1,gGeoIdentity);
    GetVol("S1A")->AddNode(GetVol("S11M"),2,new TGeoTranslation(-12.7615,0.,0.1023));
    GetVol("S1A")->AddNode(GetVol("S11M"),3,new TGeoTranslation(-7.6569,0.,0.1023));
    GetVol("S1A")->AddNode(GetVol("S11M"),4,new TGeoTranslation(-2.5523,0.,0.1023));
    GetVol("S1A")->AddNode(GetVol("S11M"),5,new TGeoTranslation(2.5523,0.,0.1023));
    GetVol("S1A")->AddNode(GetVol("S11M"),6,new TGeoTranslation(7.6569,0.,0.1023));
    GetVol("S1A")->AddNode(GetVol("S11M"),7,new TGeoTranslation(12.7615,0.,0.1023));
    GetVol("S1A")->AddNode(GetVol("S11M"),8,new TGeoTranslation(17.8661,0.,0.1023));
    GetVol("S1A")->AddNode(GetVol("POL1"),1,new TGeoTranslation(0.,0.,0.9046));

  
  SetMotherProp(GetVol("S1"),0,new TGeoTranslation(0.,0.,102.8866));

};


void  PamVMCDetTofS1::DefineCuts(){

  TString  s ="ALUMINIUM"; // default GPAMELA parameters
  if (GetMed(s) && !GetCC(s))
  SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
			     0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));
  s ="N2 GAS";
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
                             0.001, 0.01, 1., 1., 1., 0., 0., 1., 1., 4., 1., 1., 2., 1.));
  s ="SCINTILLATOR";// default GPAMELA parameters
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
			     0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));
  s ="MYLAR";
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
                             0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));
  s = "POLYSTYRENE";
    SetCC(s, new pCutControl(GetMedID(s), 0.00001, 0.00001, 0.00001, 0.00001, 0.001, 0.001, 0.01, 0.00001,
                             0.00001, 0.01, 1., 1., 1., 0., 1., 1., 1., 1., 1., 1., 1., 2.));
}

