#ifndef PAMVMCCALOID_H
#define PAMVMCCALOID_H
#include <iostream>
#include "TVirtualMC.h"
#include "pGeoID.h"

#define CALSD "CAST"
#define CALOF 3

using std::cout;
using std::endl;

struct pCalID: public pGeoID {
  Int_t casiNo;
  Int_t caplNo;
  Int_t castNo;

  pCalID(): casiNo(-1), caplNo(-1), castNo(-1) {};
  pCalID(Int_t offset): pGeoID(offset), casiNo(-1), caplNo(-1), castNo(-1) {};
  pCalID & operator = (const pCalID &pid) {
    casiNo=pid.casiNo;
    caplNo=pid.caplNo;
    castNo=pid.castNo;
    return *this;
  }

  Bool_t FillVolID(){
    Bool_t t=kFALSE;
    if(gMC) {
      	gMC->CurrentVolID(castNo);
      	gMC->CurrentVolOffID(1,casiNo);
      	gMC->CurrentVolOffID(2,caplNo);
      	t= kTRUE;
    }
    return t;
  }

  Int_t GetID() const {
    Int_t fact;
    switch(casiNo){
    case 1:
    case 2:
    case 3: 
      fact=0;
      break;
    case 4:
    case 5:
    case 6:
      fact=32;
      break;
    case 7: 
    case 8: 
    case 9:
      fact=64;
      break;
    default:
      fact=0;
      break;
    }
    // cout<<"Strip Hit pl,st:"<<caplNo-1<<" "<<castNo<<endl;
    return (caplNo-1)*96+fact+castNo; 
  }

  void Print(const Option_t* ="") const { 
    cout << " pCalID : castNo " << castNo 
	 << ", casiNo " << casiNo << ", caplNo " << caplNo 
	 << ", actual POS " << GetID() << endl;
  }

};


#endif // PAMVMCCALOID_H
