#ifndef PAM_ROOT_MANAGER_H
#define PAM_ROOT_MANAGER_H

#include <TObject.h>
#include <TTree.h>
#include <TFile.h>
#include <TDirectoryFile.h>
 
class TParticle;

enum FileMode { kRead, kWrite};

class PamRootManager : public TObject
{
  public:
    PamRootManager(const char* projectName, FileMode fileMode);
    PamRootManager();
    virtual ~PamRootManager();     
  
    // static access method
    static PamRootManager* Instance(); 

    // methods
    void  Register(const char* name, const char* className, void* objAddress);
    void  Fill();
    void  WriteAll();
    void  ReadEvent(Int_t i);
    
  private:
    // data members
    static  PamRootManager* fgInstance; //Singleton instance

    // data members
    TDirectory * fDirectory; // directory to store root-file
    TFile*  fFile;
    TTree*  fTree;
    
    ClassDef(PamRootManager,0) // Root IO manager
};

#endif //PAM_ROOT_MANAGER_H   
   

