#define ZCAL 13.05
#define CALS 10.639
#define ZSPEB 2.97
#define HORMG 22.57


void Field(){
  TString PL = gSystem->Getenv("PAM_LIB");
  gSystem->Load("libTree.so");
  gSystem->Load(PL+"/libyoda.so");
  gSystem->Load(PL+"/libDarthVader.so");
  gSystem->Load(PL+"/libPamLevel2.so");
  gSystem->Load(PL+"/libTrkParams.so");
  TString Calib=gSystem->Getenv("PAM_CALIB");
  TString pamcal = Calib+"/field_param-0/";
  TrkParams::SetPrecisionFactor(0.0000001);
  TrkParams::SetStepMin(10000);
  TrkParams::Set(pamcal,1);
  TrkParams::Load(1);

  float x[3];  // this is example when Bx=0;  

  const  Int_t n = 101;
  
  Double_t Bx[n];
  Double_t By[n];
  Double_t Bz[n];
  Double_t k[n];

  x[0]=.0;
  x[1]=.0;
  x[2]=-.5;

  x[2]=x[2]+(ZCAL+CALS+ZSPEB+HORMG);

  for (Int_t i=0; i<n; i++){
    x[2]=-50.+(float)i; 
    
    Bx[i]=TrkParams::GetBX((float *)x)*10.;
    By[i]=TrkParams::GetBY((float *)x)*10.;
    Bz[i]=TrkParams::GetBZ((float *)x)*10.;
x[2]=x[2]+(ZCAL+CALS+ZSPEB+HORMG);
    cout<<"X="<<x[0]<<" Y="<<x[1]<<" Z="<<x[2]<<" Bx="<<Bx[i]<<" By="<<By[i]<<" Bz="<<Bz[i]<<endl;
    k[i]=x[2];
  }
  
   TGraph *bx = new TGraph(n,k,Bx);
   TGraph *by = new TGraph(n,k,By);
   TGraph *bz = new TGraph(n,k,Bz);
   TMultiGraph *mg = new TMultiGraph();
   mg->Add(bx);
   mg->Add(by);
    mg->Add(bz);
   TCanvas *c = new TCanvas("Mag","Magnetic Field",200,10,600,400);
   mg->Draw("AC");

}
