#include "PamVMCDetCas.h"

ClassImp(PamVMCDetCas)

void  PamVMCDetCas::DefineGeometry(){

  TGeoMaterial *m=0;
  TGeoMixture *x=0;
  TString s = "ALUMINIUM"; 
  m = GetMat(s);
  if(!m){   
    m = new TGeoMaterial(s,26.98,13,2.7);
    m->SetUniqueID( 9);
  }


  s = "SCINT";
  x = (TGeoMixture*)GetMat(s);  
  if(!x){ 
    x = new TGeoMixture(s,2,   1.03200    );
    x->SetUniqueID( 17);
    x->DefineElement(0,12.01,6,0.922427);
    x->DefineElement(1,1.01,1,0.7757296E-01);
  }

  s = "N2GAS";
  m = GetMat(s);
  if (!m){
    m = new TGeoMaterial(s,14.01,7,0.1250000E-02);
    m->SetUniqueID( 19);
  }

  s = "PLAST";
  x = (TGeoMixture*)GetMat(s);
   if(!x){
     x = new TGeoMixture(s,2,   1.03200    );
     x->SetUniqueID(28);
     x->DefineElement(0,12.01,6,0.9929774);
     x->DefineElement(1,1.01,1,0.7022570E-02);
   }

   TGeoMedium *n =0;
   
  s="ALUMINIUM";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,1,9,-1,1,40,1,100,0.5000000E-01,0.136283,0.5000000E-03);

  s = "N2 GAS";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,3,19,-1,1,40,1,0.5000000E-01,0.5000000E-01,0.1000000E-02,0.5000000E-03);

  s = "SCINTILLATOR";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,10,17,1,1,40,1,0.5000000E-01,0.5000000E-01,0.1000000E-01,0.5000000E-03);

  s = "PLASTIC";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,18,28,-1,1,40,1,100,0.5000000E-01,0.1000000E-01,0.5000000E-03);


  TGeoVolume *v = 0;


  s = "CASA";
  v = (GetVol(s))?GetVol(s):gGeoManager->MakeBox("CASA",GetMed("N2 GAS"),21.45,0.6,20.55);
  s = "STRP";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox("STRP",GetMed("ALUMINIUM"),21.45,0.6,20.55);
  s = "SID1";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox("SID1",GetMed("SCINTILLATOR"),20.3,0.4,19.4);
  s = "PLA1";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox("PLA1",GetMed("PLASTIC"),21.1,0.4,20.2);
  s = "STP1";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeTrap("STP1",GetMed("PLASTIC"),16.1,7.361412634,0.,0.4,0.,0.,0.,0.4,4.16,4.16,0.);
  s = "STP2";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeTrap("STP2",GetMed("PLASTIC"),2.4,20.55604522,0.,0.4,0.,0.,0.,0.4,1.8,1.8,0.);
  s = "STP3";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeTrap("STP3",GetMed("PLASTIC"),0.9,58.17255342,0.,0.4,1.8,1.8,0.,0.4,4.7,4.7,0.);
  s = "STA1";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeTrap("STA1",GetMed("ALUMINIUM"),16.5,7.355684758,0.,0.4,0.,0.,0.,0.4,4.26,4.26,0.);
  s = "STA2"; 
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeTrap("STA2",GetMed("ALUMINIUM"),2.8,21.44773633,0.,0.4,0.,0.,0.,0.4,2.2,2.2,0.);
  s = "STA3";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeTrap("STA3",GetMed("ALUMINIUM"),0.9,58.17255342,0.,0.4,2.2,2.2,0.,0.4,5.1,5.1,0.);
  s = "STL1";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeTrap("STL1",GetMed("N2 GAS"),16.675,7.355377512,0.,0.6,0.,0.,0.,0.6,4.305,4.305,0.);
  s = "STL2";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeTrap("STL2",GetMed("N2 GAS"),2.8,21.44773633,0.,0.6,0.,0.,0.,0.6,2.2,2.2,0.);
  s = "STL3";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeTrap("STL3",GetMed("N2 GAS"),1.075,58.18078646,0.,0.6,2.15,2.15,0.,0.6,5.615,5.615,0.);


  GetVol("CASA")->AddNode(GetVol("STRP"),1,gGeoIdentity);
    GetVol("STRP")->AddNodeOverlap(GetVol("PLA1"),1,gGeoIdentity);
      GetVol("PLA1")->AddNodeOverlap(GetVol("SID1"),1,gGeoIdentity);
        GetVol("SID1")->AddNode(GetVol("STP1"),1,new TGeoCombiTrans(18.22,0.,-3.3,GetRot("rot5")));
	GetVol("SID1")->AddNode(GetVol("STP2"),1,new TGeoCombiTrans(19.4,0.,15.2,GetRot("rot4")));
	GetVol("SID1")->AddNode(GetVol("STP3"),1,new TGeoCombiTrans(17.05,0.,18.5,GetRot("rot4")));
      GetVol("PLA1")->AddNode(GetVol("STA1"),1,new TGeoCombiTrans(18.97,0.,-3.7,GetRot("rot5")));
      GetVol("PLA1")->AddNode(GetVol("STA2"),1,new TGeoCombiTrans(20.,0.,15.6,GetRot("rot4")));
      GetVol("PLA1")->AddNode(GetVol("STA3"),1,new TGeoCombiTrans(17.45,0.,19.3,GetRot("rot4")));
    GetVol("STRP")->AddNode(GetVol("STL1"),1,new TGeoCombiTrans(19.2975,0.,-3.875,GetRot("rot5")));
    GetVol("STRP")->AddNode(GetVol("STL2"),1,new TGeoCombiTrans(20.35,0.,15.6,GetRot("rot4")));
    GetVol("STRP")->AddNode(GetVol("STL3"),1,new TGeoCombiTrans(17.5675,0.,19.475,GetRot("rot4")));
  
  SetMotherProp(GetVol("CASA"),1,new TGeoTranslation(8.872,-17.215,47.174));
  SetMotherProp(GetVol("CASA"),2,new TGeoCombiTrans(17.9285,6.305,47.174,GetRot("rot1")));
  SetMotherProp(GetVol("CASA"),3,new TGeoCombiTrans(-5.5095,17.215,47.174,GetRot("rot4")));
  SetMotherProp(GetVol("CASA"),4,new TGeoCombiTrans(-17.9285,-10.195,47.174,GetRot("rot6")));

};


void  PamVMCDetCas::DefineCuts(){

 TString  s ="ALUMINIUM"; // default GPAMELA parameters
  if (GetMed(s) && !GetCC(s))
  SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
			     0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));
  s ="N2 GAS";
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
                             0.001, 0.01, 1., 1., 1., 0., 0., 1., 1., 4., 1., 1., 2., 1.));
  s ="SCINTILLATOR";// default GPAMELA parameters
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
			     0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));
  s = "PLASTIC";// default GPAMELA parameters
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
			     0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));   

}

