#include "PamVMCDigRunHeader.h"

ClassImp(PamVMCDigRunHeader)
#include "CRC.h"
void PamVMCDigRunHeader:: DigitizeRunHeader(){
  
  UChar_t buffRH[37];

  // header: 16 bytes
  DigitizePSCU(37,0x20);
  
  // time stamp (uint32): 0x82569c97
  buffRH[0] = 0x82; //17
  buffRH[1] = 0x56;
  buffRH[2] = 0x9C;
  buffRH[3] = 0x97;  //20

  // acq_setting_mode (uint8)
  buffRH[4] = 0x02; 

  // obt (uint32)
  ULong64_t obt = fraw->GetOBT() + 30LL;
  while ( obt > 4294967295LL )
    obt -= 4294967295LL;
  UInt_t Uobt = UInt_t(obt);
  fraw->SetOBT(Uobt);
  
  
  buffRH[5] = (UChar_t)(Uobt >> 24); //22
  buffRH[6] = (UChar_t)(Uobt >> 16);
  buffRH[7] = (UChar_t)(Uobt >> 8);
  buffRH[8] = (UChar_t)Uobt;  //25
  
  // last time_sync_info (uint32)  (from file 000_001_00110)
  buffRH[9] = 0x00;  //26
  buffRH[10] = 0x08; 
  buffRH[11] = 0x68; 
  buffRH[12] = 0xEF;   //29

  // fav. working schedule (uint8)
  buffRH[13] = 0x00; 

  // eff. working schedule (uint8)
  buffRH[14] = 0x00;//0; 

  // trigger_mode_A (uint32)
  buffRH[15] = 0x00;  //32
  buffRH[16] = 0x00; 
  buffRH[17] = 0x00; 
  buffRH[18] = 0x01;  //35

  // trigger_mode_B (uint32)
  buffRH[19] = 0x00;  //36
  buffRH[20] = 0x00; 
  buffRH[21] = 0x00; 
  buffRH[22] = 0x03; //39

  // acq_after_calib (0,1) (uint8)
  buffRH[23] = 0x00; 

  // trk_calib_used (uint32)
  buffRH[24] = 0x00;  //41
  buffRH[25] = 0x00; 
  buffRH[26] = 0x00; 
  buffRH[27] = 0x68; //44

  // acq_build_info (4 zero bits + 28 1's) (uint32)
  buffRH[28] = 0x3F; //45
  buffRH[29] = 0xFF; 
  buffRH[30] = 0xFF; 
  buffRH[31] = 0xFF;  //48

  // acq_var_info (11 bits) (uint16)
  buffRH[32] = 0x23;
  buffRH[33] = 0x7F;

  // cal_dsp_mask (uint8)
  buffRH[34] = 0x00; //51 [50]
  // 
  
  
  UShort_t crcRH = (UShort_t)CM_Compute_CRC16((UINT16)0, (BYTE*)&buffRH, (UINT32)(35));

  buffRH[35] = ((UChar_t)(crcRH >> 8)); //52
  buffRH[36] = ((UChar_t)crcRH); //53 [52]


  for(Int_t i=0; i<37; i++) fDataPSCU.push_back(buffRH[i]);
  
}


void PamVMCDigRunHeader::WriteRunHeader(){
  
  fraw->WritePSCU(&fDataPSCU);
}

