static Int_t    eventsPerRun = 100;
enum PprGeo_t
{
    kHoles, kNoHoles
};
                                                                                
enum PprRad_t
{
    kGluonRadiation, kNoGluonRadiation
};
                                                                                
enum PprMag_t
{
    k2kG, k4kG, k5kG
};
                                                                                
                                                                                
// This part for configuration
static PprGeo_t sgeo = kHoles;
static PprRad_t srad = kGluonRadiation;
static PprMag_t smag = k5kG;
                                                                                
// Comment line
static TString  comment;
                                                                                
// Functions
Float_t EtaToTheta(Float_t arg);


void Config()
{
  cout << "==> Config.C..." << endl;
  
  // Set Random Number seed
//   gRandom->SetSeed(771967.);
//   cout<<"Seed for random number generation= "<<gRandom->GetSeed()<<endl;

  
  
  // libraries required by fluka21

  Bool_t isFluka = kTRUE;
  if (isFluka) {
    gSystem->Load("libGeom");
    cout << "\t* Loading TFluka..." << endl;  
    //    gSystem->Load("libTFluka");    
    gSystem->Load("libfluka");    
    
    cout << "\t* Instantiating TFluka..." << endl;
    new  TFluka("C++ Interface to Fluka", 0/*verbositylevel*/);
    //new  TFluka("C++ Interface to Fluka", 4);
  }
  else {
    cout << "\t* Loading Geant3..." << endl;  
    gSystem->Load("libgeant321");
    
    cout << "\t* Instantiating Geant3TGeo..." << endl;
    new     TGeant3TGeo("C++ Interface to Geant3");
  }
  
  // Physics process control

//   gMC->SetProcess("DCAY",1);
//   gMC->SetProcess("PAIR",1);
//   gMC->SetProcess("COMP",1);
//   gMC->SetProcess("PHOT",1);
//   gMC->SetProcess("PFIS",0);
//   gMC->SetProcess("DRAY",1);
//   gMC->SetProcess("ANNI",1);
//   gMC->SetProcess("BREM",1);
//   gMC->SetProcess("MUNU",1);
//   gMC->SetProcess("CKOV",1); 
//   gMC->SetProcess("HADR",1);
//   gMC->SetProcess("LOSS",2);
//   gMC->SetProcess("MULS",1);
//   gMC->SetProcess("RAYL",1);
                                                                                
  Float_t cut = 1.e-5;        // 1MeV cut by default
  Float_t tofmax = 1.e10;
                                                                                
  gMC->SetCut("CUTGAM", cut);
  gMC->SetCut("CUTELE", cut);
  gMC->SetCut("CUTNEU", cut);
  gMC->SetCut("CUTHAD", cut);
  gMC->SetCut("CUTMUO", cut);
  gMC->SetCut("BCUTE",  cut);
  gMC->SetCut("BCUTM",  cut);
  gMC->SetCut("DCUTE",  cut);
  gMC->SetCut("DCUTM",  cut);
  gMC->SetCut("PPCUTM", cut);
  gMC->SetCut("TOFMAX", tofmax);

  cout << "==> Config.C is over ..." << endl;

}
                                                                                
Float_t EtaToTheta(Float_t arg){
  return (180./TMath::Pi())*2.*atan(exp(-arg));
}

